/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.server.business;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import de.justsoftware.onx.server.business.ClusterPosition;
import de.justsoftware.onx.server.business.JucoVersionUpdateProcessInfo;
import de.justsoftware.onx.server.business.UpdateBehaviour;
import de.justsoftware.onx.server.integration.persistence.model.DBJucoVersionUpdateProcess;
import de.justsoftware.onx.server.model.ComparableVersion;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public final class ApplyOnceOnMasterUpdateBehaviour
implements UpdateBehaviour {
    private static final Logger LOG = LoggerFactory.getLogger(ApplyOnceOnMasterUpdateBehaviour.class);
    private final String _minVersionToApplyFor;
    private final JucoVersionUpdateProcessInfo _process;

    ApplyOnceOnMasterUpdateBehaviour(JucoVersionUpdateProcessInfo process, String minVersionToApplyFor) {
        this._process = process;
        this._minVersionToApplyFor = minVersionToApplyFor;
    }

    @Override
    public boolean applyForNewVersion(String currentVersion, UpdateBehaviour.UpdateProcessInformationProvider infoProvider) {
        boolean applyForNewVersion;
        Optional<DBJucoVersionUpdateProcess> lastExecution = infoProvider.getLastExecutionOnAnyHost(this._process.getProcessType());
        boolean bl = applyForNewVersion = infoProvider.getClusterPosition() == ClusterPosition.MASTER && (!lastExecution.isPresent() || ((DBJucoVersionUpdateProcess)lastExecution.get()).getProcessorVersion() < this._process.getProcessorVersion()) && new ComparableVersion(this._minVersionToApplyFor).compareTo(new ComparableVersion(currentVersion)) <= 0;
        if (applyForNewVersion) {
            LOG.info("Update process {} was not executed yet on any host and will be applied for version {}.", (Object)this._process.asVersionString(), (Object)currentVersion);
        }
        return applyForNewVersion;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof ApplyOnceOnMasterUpdateBehaviour && Objects.equal((Object)this._minVersionToApplyFor, (Object)((ApplyOnceOnMasterUpdateBehaviour)obj)._minVersionToApplyFor) && Objects.equal((Object)this._process, (Object)((ApplyOnceOnMasterUpdateBehaviour)obj)._process);
    }

    public int hashCode() {
        return this.getClass().getName().hashCode() ^ Objects.hashCode((Object[])new Object[]{this._minVersionToApplyFor, this._process});
    }
}

