/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.web.authentication;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;

@ParametersAreNonnullByDefault
public class DelegatingAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    private ImmutableList<AuthenticationSuccessHandler> _handlers = ImmutableList.of();

    public void setSuccessHandlers(Iterable<AuthenticationSuccessHandler> handlers) {
        this._handlers = ImmutableList.copyOf(handlers);
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        for (AuthenticationSuccessHandler handler : this._handlers) {
            handler.onAuthenticationSuccess(request, response, authentication);
        }
    }
}

