/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.trusteddevice.integration.persistence;

import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.security.trusteddevice.integration.persistence.AccountLockDAO;
import de.justsoftware.onx.security.trusteddevice.integration.persistence.mapper.AccountLockMapper;
import de.justsoftware.onx.security.trusteddevice.integration.persistence.model.DBAccountLock;
import java.time.LocalDateTime;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class AccountLockDAOImpl
implements AccountLockDAO {
    private final AccountLockMapper _mapper;

    @Autowired
    public AccountLockDAOImpl(AccountLockMapper mapper) {
        this._mapper = mapper;
    }

    @Override
    public Optional<DBAccountLock> getAccountLockForPerson(PersonId personId) {
        return Optional.ofNullable(this._mapper.getAccountLockByPerson(personId));
    }

    @Override
    public void insertOrUpdateAccountLock(PersonId personId, LocalDateTime lockedUntil) {
        this._mapper.upsertAccountLockForPerson(personId, lockedUntil);
    }

    @Override
    public void deleteAccountLockForPerson(PersonId personId) {
        this._mapper.deleteAccountLockForPerson(personId);
    }
}

