/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.trusteddevice.business.impl;

import de.justsoftware.jwtfilter.generator.JwtClaimsBuilder;
import de.justsoftware.jwtfilter.generator.JwtGenerator;
import de.justsoftware.jwtfilter.keys.JwtKeyLoadingException;
import de.justsoftware.jwtfilter.verifier.JwtVerificationConstraintBuilder;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.security.trusteddevice.business.TrustedDeviceTokenService;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class TrustedDeviceTokenServiceImpl
implements TrustedDeviceTokenService {
    private static final Logger LOG = LoggerFactory.getLogger(TrustedDeviceTokenServiceImpl.class);
    private final JwtVerifier _jwtVerifier;
    private final JwtGenerator _jwtGenerator;

    @Autowired
    public TrustedDeviceTokenServiceImpl(@Qualifier(value="signedJwtVerifier") JwtVerifier jwtVerifier, @Qualifier(value="signedJwtGenerator") JwtGenerator jwtGenerator) {
        this._jwtVerifier = jwtVerifier;
        this._jwtGenerator = jwtGenerator;
    }

    @Override
    public boolean isTokenValidForUser(String trustedDeviceToken, ProfileId profileId) {
        JwtVerificationConstraintBuilder constraintBuilder = new JwtVerificationConstraintBuilder().withRequireSubject();
        try {
            JwtClaims claims = this._jwtVerifier.verify(constraintBuilder, trustedDeviceToken);
            ProfileId tokenOwner = Objects.requireNonNull(PersonId.parse(claims.getSubject())).asProfileId();
            if (profileId.equals(tokenOwner)) {
                return true;
            }
        }
        catch (JwtKeyLoadingException e) {
            LOG.error("Could not load keys to verify trusted-device tokens. This should never happen...", (Throwable)e);
            return true;
        }
        catch (NullPointerException | MalformedClaimException | InvalidJwtException e) {
            return false;
        }
        return false;
    }

    @Override
    public Optional<String> issueToken(ProfileId profileId, Duration lifetime) {
        try {
            JwtClaimsBuilder claimsBuilder = new JwtClaimsBuilder().withSubject(profileId.toString()).withLifetime(lifetime.toMinutes());
            return Optional.of(this._jwtGenerator.generateJWT(claimsBuilder));
        }
        catch (JwtKeyLoadingException | JoseException e) {
            LOG.error("Failed to create JWT for device cookie:", e);
            return Optional.empty();
        }
    }
}

