/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.trusteddevice.business.impl;

import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.util.CookieUtil;
import de.justsoftware.onx.security.SecurityUtils;
import de.justsoftware.onx.security.trusteddevice.business.TrustedDeviceCookieService;
import de.justsoftware.onx.security.trusteddevice.business.TrustedDeviceService;
import java.time.Duration;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.stereotype.Service;

@Service(value="trustedDeviceCookieManager")
public class TrustedDeviceCookieManagerImpl
implements AuthenticationSuccessHandler,
RememberMeServices,
TrustedDeviceCookieService {
    private final TrustedDeviceService _trustedDeviceService;
    private final Duration _cookieMaxAge;

    public TrustedDeviceCookieManagerImpl(TrustedDeviceService trustedDeviceService, @Value(value="${just.security.trusteddevicecookie.maxAgeInDays:30}") int cookieMaxAgeInDays) {
        this._trustedDeviceService = trustedDeviceService;
        this._cookieMaxAge = Duration.ofDays(cookieMaxAgeInDays);
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        this.addCookie(request, response, authentication);
    }

    @Nonnull
    private Optional<String> createDeviceCookieTokenFromAuthentication(Authentication successfulAuthentication) {
        return Optional.ofNullable(SecurityUtils.getUserIdOrNull(successfulAuthentication)).flatMap(this::createDeviceCookieTokenFromPersonId);
    }

    @Nonnull
    private Optional<String> createDeviceCookieTokenFromPersonId(PersonId personId) {
        return this._trustedDeviceService.issueTrustedDeviceToken(personId.asProfileId(), this._cookieMaxAge);
    }

    private void addCookie(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        this.createDeviceCookieTokenFromAuthentication(authentication).ifPresent(token -> this.writeCookie(request, response, (String)token));
    }

    private void writeCookie(HttpServletRequest request, HttpServletResponse response, String token) {
        CookieUtil.newCookie("trusted-device", token).httpOnly(true).maxAge((int)this._cookieMaxAge.getSeconds()).request(request).add(response);
    }

    @Override
    public void addTrustedDeviceCookieForPerson(HttpServletRequest request, HttpServletResponse response, PersonId personId) {
        this.createDeviceCookieTokenFromPersonId(personId).ifPresent(token -> this.writeCookie(request, response, (String)token));
    }

    public Authentication autoLogin(HttpServletRequest request, HttpServletResponse response) {
        return null;
    }

    public void loginFail(HttpServletRequest request, HttpServletResponse response) {
    }

    public void loginSuccess(HttpServletRequest request, HttpServletResponse response, Authentication successfulAuthentication) {
        this.addCookie(request, response, successfulAuthentication);
    }
}

