/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.trusteddevice.business;

import de.justsoftware.onx.common.shared.model.PersonId;
import javax.annotation.CheckForNull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@ParametersAreNonnullByDefault
public interface TrustedDeviceCookieService {
    public static final String DEVICE_COOKIE_NAME = "trusted-device";

    public void addTrustedDeviceCookieForPerson(HttpServletRequest var1, HttpServletResponse var2, PersonId var3);

    @CheckForNull
    default public String getTrustedDeviceJwt(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(DEVICE_COOKIE_NAME)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }
}

