/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.service.impl;

import com.google.common.base.Charsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.RandomStringUtils;

@ParametersAreNonnullByDefault
final class Passwords {
    private static final int SALT_LENGTH = 5;

    Passwords() {
    }

    @Nonnull
    private static String encodeMd5(String plainPassword, String salt) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(salt.getBytes(Charsets.UTF_8));
            byte[] digest = md5.digest(plainPassword.getBytes(Charsets.UTF_8));
            String base64Encoded = new String(Base64.encodeBase64((byte[])digest), Charsets.UTF_8);
            return base64Encoded.substring(0, base64Encoded.length() - 2);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("the jre does not support md5", e);
        }
    }

    static boolean verifyPassword(String plainPassword, @Nullable String hashedPassword) {
        if (hashedPassword == null) {
            return false;
        }
        String[] saltAndHash = hashedPassword.split("\\$");
        if (saltAndHash.length < 2) {
            return false;
        }
        String salt = saltAndHash[0];
        String md5Hash = saltAndHash[1];
        return Passwords.encodeMd5(plainPassword, salt).equals(md5Hash);
    }

    @Nonnull
    static String hashPassword(String plainPassword) {
        String salt = RandomStringUtils.randomAlphanumeric((int)5);
        return Passwords.hashPassword(plainPassword, salt);
    }

    @Nonnull
    static String hashPassword(String plainPassword, String salt) {
        return salt + "$" + Passwords.encodeMd5(plainPassword, salt);
    }
}

