/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.service.impl;

import de.justsoftware.onx.person.business.PersonAccessor;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.security.SecurityUtils;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service(value="userDetailsService")
public class JustConnectUserDetailServiceImpl
implements UserDetailsService {
    private final PersonAccessor _personAccessor;

    @Autowired
    @ParametersAreNonnullByDefault
    public JustConnectUserDetailServiceImpl(PersonAccessor personAccessor) {
        this._personAccessor = personAccessor;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        DBPerson dbPerson = this._personAccessor.getPersonByUsername(username);
        if (dbPerson == null) {
            throw new UsernameNotFoundException("No just connect user found with username " + username);
        }
        return SecurityUtils.getJustConnectUser(dbPerson);
    }
}

