/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.service.impl;

import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.person.business.PersonWriteDataService;
import de.justsoftware.onx.security.model.JustConnectUser;
import de.justsoftware.onx.security.service.JucoPasswordEncoder;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Service;

@Service(value="jucoDatabaseAuthenticationProvider")
@ParametersAreNonnullByDefault
public class JucoDatabaseAuthenticationProvider
extends DaoAuthenticationProvider {
    private final PersonWriteDataService _personWriteDataService;
    private final JucoPasswordEncoder _passwordEncoder;

    @Autowired
    public JucoDatabaseAuthenticationProvider(@Qualifier(value="userDetailsService") UserDetailsService userDetailsService, PersonWriteDataService personWriteDataService, JucoPasswordEncoder passwordEncoder) {
        this._personWriteDataService = personWriteDataService;
        this._passwordEncoder = passwordEncoder;
        this.setUserDetailsService(userDetailsService);
        this.setPasswordEncoder(passwordEncoder);
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) {
        super.additionalAuthenticationChecks(userDetails, authentication);
        if (userDetails instanceof JustConnectUser && this._passwordEncoder.upgradeEncoding(userDetails.getPassword())) {
            String newPassword = this.getPasswordEncoder().encode((CharSequence)authentication.getCredentials().toString());
            JustConnectUser justConnectUser = (JustConnectUser)userDetails;
            this._personWriteDataService.updatePassword(new PersonId(justConnectUser.getId()), newPassword);
            justConnectUser.setPassword(newPassword);
        }
    }
}

