/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.oauth.integration.persistence.model;

import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.security.oauth.business.server.model.OAuthClientId;
import java.io.Serializable;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DBOAuthClient
implements Serializable {
    private static final long serialVersionUID = 1L;
    private OAuthClientId _clientId;
    private String _clientSecret;
    private String _scope;
    private String _authorizedGrantTypes;
    private String _authorities;
    private Integer _refreshTokenValiditySeconds;
    private Integer _accessTokenValiditySeconds;
    private String _autoApprovedScopes;
    private String _registeredRedirectUri;

    @Deprecated
    protected DBOAuthClient() {
    }

    public DBOAuthClient(OAuthClientId clientId, @Nullable String clientSecret, String scope, String authorizedGrantTypes, String authorities, @Nullable Integer refreshTokenValiditySeconds, @Nullable Integer accessTokenValiditySeconds, @Nullable String autoApproveScopes) {
        this._clientId = clientId;
        this._clientSecret = clientSecret;
        this._scope = scope;
        this._authorizedGrantTypes = authorizedGrantTypes;
        this._authorities = authorities;
        this._refreshTokenValiditySeconds = refreshTokenValiditySeconds;
        this._accessTokenValiditySeconds = accessTokenValiditySeconds;
        this._autoApprovedScopes = autoApproveScopes;
    }

    @Nonnull
    public OAuthClientId getClientId() {
        return this._clientId;
    }

    public void setClientId(OAuthClientId clientId) {
        this._clientId = clientId;
    }

    @CheckForNull
    public String getClientSecret() {
        return this._clientSecret;
    }

    public void setClientSecret(@Nullable String clientSecret) {
        this._clientSecret = clientSecret;
    }

    @Nonnull
    public String getScope() {
        return this._scope;
    }

    public void setScope(String scope) {
        this._scope = scope;
    }

    @Nonnull
    public String getAuthorizedGrantTypes() {
        return this._authorizedGrantTypes;
    }

    public void setAuthorizedGrantTypes(String authorizedGrantTypes) {
        this._authorizedGrantTypes = authorizedGrantTypes;
    }

    @Nonnull
    public String getAuthorities() {
        return this._authorities;
    }

    public void setAuthorities(String authorities) {
        this._authorities = authorities;
    }

    @CheckForNull
    public Integer getRefreshTokenValiditySeconds() {
        return this._refreshTokenValiditySeconds;
    }

    public void setRefreshTokenValiditySeconds(@Nullable Integer refreshTokenValiditySeconds) {
        this._refreshTokenValiditySeconds = refreshTokenValiditySeconds;
    }

    @CheckForNull
    public Integer getAccessTokenValiditySeconds() {
        return this._accessTokenValiditySeconds;
    }

    public void setAccessTokenValiditySeconds(@Nullable Integer accessTokenValiditySeconds) {
        this._accessTokenValiditySeconds = accessTokenValiditySeconds;
    }

    @CheckForNull
    public String getAutoApprovedScopes() {
        return this._autoApprovedScopes;
    }

    public void setAutoApprovedScopes(@Nullable String scopes) {
        this._autoApprovedScopes = scopes;
    }

    @CheckForNull
    public String getRegisteredRedirectUri() {
        return this._registeredRedirectUri;
    }

    public void setRegisteredRedirectUri(@Nullable String registeredRedirectUri) {
        this._registeredRedirectUri = registeredRedirectUri;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("clientId", (Object)this._clientId).add("clientSecret", (Object)(StringUtil.isBlank(this._clientSecret) ? "*******" : "no secret")).add("scope", (Object)this._scope).add("authorizedGrantTypes", (Object)this._authorizedGrantTypes).add("authorities", (Object)this._authorities).add("accessTokenValiditySeconds", (Object)this._accessTokenValiditySeconds).add("refreshTokenValiditySeconds", (Object)this._refreshTokenValiditySeconds).add("autoApproveScopes", (Object)this._autoApprovedScopes).add("registeredRedirectUri", (Object)this._registeredRedirectUri).toString();
    }
}

