/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.oauth.integration.persistence.ibatis;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.common.integration.persistence.DAOException;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStandardResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.security.oauth.business.server.model.OAuthClientId;
import de.justsoftware.onx.security.oauth.integration.persistence.OAuthClientDAO;
import de.justsoftware.onx.security.oauth.integration.persistence.model.DBOAuthClient;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ibatisOAuthClientDAO")
@ParametersAreNonnullByDefault
public class IbatisOAuthClientDAO
implements OAuthClientDAO {
    private static final Logger LOG = LoggerFactory.getLogger(IbatisOAuthClientDAO.class);
    private final IbatisStatementBuilder _statementBuilder;

    @Autowired
    public IbatisOAuthClientDAO(StatementBuilderFactory statementBuilderFactory) {
        this._statementBuilder = statementBuilderFactory.ibatistStatementBuilder("OAuthClient");
    }

    @Override
    public int createClient(OAuthClientId clientId, String clientSecret, String scope, String authorizedGrantTypes, String authorities, Integer accessTokenValiditySeconds, Integer refreshTokenValiditySeconds, String redirectUris) {
        ImmutableMap.Builder nonNullMap = ImmutableMap.builder().put((Object)"clientId", (Object)clientId).put((Object)"scope", (Object)scope).put((Object)"authorizedGrantTypes", (Object)authorizedGrantTypes).put((Object)"authorities", (Object)authorities);
        if (clientSecret != null) {
            nonNullMap.put((Object)"clientSecret", (Object)clientSecret);
        }
        if (accessTokenValiditySeconds != null) {
            nonNullMap.put((Object)"accessTokenValiditySeconds", (Object)accessTokenValiditySeconds);
        }
        if (refreshTokenValiditySeconds != null) {
            nonNullMap.put((Object)"refreshTokenValiditySeconds", (Object)refreshTokenValiditySeconds);
        }
        if (redirectUris != null) {
            nonNullMap.put((Object)"redirectUris", (Object)redirectUris);
        }
        try {
            this._statementBuilder.insert("insertClient").param(nonNullMap.build()).orNull();
            return 1;
        }
        catch (DAOException e) {
            LOG.error("error inserting oauth client {} : {}", (Object)clientId, (Object)e.getMessage());
            return 0;
        }
    }

    @Override
    public ImmutableList<DBOAuthClient> getAllClients() {
        try {
            return ((IbatisStandardResultBuilder)this._statementBuilder.select("selectAllClients").noParam()).asList();
        }
        catch (DAOException e) {
            LOG.error("error fetching all oauth clients : {}", (Object)e.getMessage());
            return ImmutableList.of();
        }
    }

    @Override
    public int updateClientById(OAuthClientId clientId, String scope, String authorizedGrantTypes, String authorities, Integer accessTokenValiditySeconds, Integer refreshTokenValiditySeconds, String redirectUris) {
        ImmutableMap.Builder nonNullMap = ImmutableMap.builder().put((Object)"clientId", (Object)clientId).put((Object)"scope", (Object)scope).put((Object)"authorizedGrantTypes", (Object)authorizedGrantTypes).put((Object)"authorities", (Object)authorities);
        if (accessTokenValiditySeconds != null) {
            nonNullMap.put((Object)"accessTokenValiditySeconds", (Object)accessTokenValiditySeconds);
        }
        if (refreshTokenValiditySeconds != null) {
            nonNullMap.put((Object)"refreshTokenValiditySeconds", (Object)refreshTokenValiditySeconds);
        }
        if (redirectUris != null) {
            nonNullMap.put((Object)"redirectUris", (Object)redirectUris);
        }
        try {
            return this._statementBuilder.update("updateClient").param(nonNullMap.build());
        }
        catch (DAOException e) {
            LOG.error("error updating oauth client for {} : {}", (Object)clientId, (Object)e.getMessage());
            return 0;
        }
    }

    @Override
    public int updateClientSecretById(OAuthClientId clientId, String clientSecret) {
        ImmutableMap.Builder nonNullMap = ImmutableMap.builder().put((Object)"clientId", (Object)clientId);
        if (clientSecret != null) {
            nonNullMap.put((Object)"clientSecret", (Object)clientSecret);
        }
        try {
            return this._statementBuilder.update("updateClientSecret").param(nonNullMap.build());
        }
        catch (DAOException e) {
            LOG.error("error updating oauth client secret for {} : {}", (Object)clientId, (Object)e.getMessage());
            return 0;
        }
    }

    @Override
    public int deleteClientsById(Set<OAuthClientId> ids) {
        try {
            return (Integer)this._statementBuilder.delete("deleteClient").partition(ids);
        }
        catch (DAOException e) {
            LOG.error("error deleting oauth clients of {} : {}", ids, (Object)e.getMessage());
            return 0;
        }
    }
}

