/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.oauth.business.server.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.security.oauth.business.server.model.OAuthAccessTokenId;
import de.justsoftware.onx.security.oauth.business.server.model.OAuthClientId;
import de.justsoftware.onx.security.oauth.business.server.model.OAuthRefreshTokenId;
import de.justsoftware.onx.util.shared.NullIsFalsePredicate;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.springframework.security.oauth2.common.DefaultExpiringOAuth2RefreshToken;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.DefaultOAuth2RefreshToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;

@ParametersAreNonnullByDefault
public class OAuthToken
implements Serializable {
    public static final String PROFILE_ID_KEY = "profileId";
    public static final Function<OAuthToken, OAuthAccessTokenId> TO_ACCESS_TOKEN_ID = new NullPermeableFunction<OAuthToken, OAuthAccessTokenId>(){

        @Override
        protected OAuthAccessTokenId applySafe(OAuthToken token) {
            return token.getAccessToken();
        }
    };
    public static final Function<OAuthToken, OAuth2AccessToken> TO_ACCESS_TOKEN = new NullPermeableFunction<OAuthToken, OAuth2AccessToken>(){

        @Override
        protected OAuth2AccessToken applySafe(OAuthToken token) {
            DefaultOAuth2AccessToken result = new DefaultOAuth2AccessToken(token.getAccessToken().getId());
            result.setExpiration(token.getAccessTokenExpiry().toDate());
            result.setScope(token.getScope());
            result.setRefreshToken((OAuth2RefreshToken)TO_REFRESH_TOKEN.apply((Object)token));
            PersonId personId = token.getPersonId();
            if (personId != null) {
                result.setAdditionalInformation((Map)ImmutableMap.of((Object)OAuthToken.PROFILE_ID_KEY, (Object)personId.asProfileId()));
            }
            return result;
        }
    };
    public static final Function<OAuthToken, OAuth2RefreshToken> TO_REFRESH_TOKEN = new NullPermeableFunction<OAuthToken, OAuth2RefreshToken>(){

        @Override
        protected OAuth2RefreshToken applySafe(OAuthToken token) {
            OAuthRefreshTokenId refreshToken = token.getRefreshToken();
            DateTime refreshTokenExpiry = token.getRefreshTokenExpiry();
            return refreshToken != null ? (refreshTokenExpiry != null ? new DefaultExpiringOAuth2RefreshToken(refreshToken.getId(), refreshTokenExpiry.toDate()) : new DefaultOAuth2RefreshToken(refreshToken.getId())) : null;
        }
    };
    private static final long serialVersionUID = 1L;
    private final OAuthAccessTokenId _accessToken;
    private final DateTime _accessTokenExpiry;
    private final OAuthRefreshTokenId _refreshToken;
    private final DateTime _refreshTokenExpiry;
    private final OAuthClientId _clientId;
    private final ImmutableSet<String> _scope;
    private final String _grantType;
    private final PersonId _personId;

    public OAuthToken(OAuthAccessTokenId accessToken, DateTime accessTokenExpiry, @Nullable OAuthRefreshTokenId refreshToken, @Nullable DateTime refreshTokenExpiry, OAuthClientId clientId, Iterable<String> scope, String grantType, @Nullable PersonId personId) {
        this._accessToken = accessToken;
        this._accessTokenExpiry = accessTokenExpiry;
        this._refreshToken = refreshToken;
        this._refreshTokenExpiry = refreshTokenExpiry;
        this._clientId = clientId;
        this._scope = ImmutableSet.copyOf(scope);
        this._grantType = grantType;
        this._personId = personId;
    }

    @Nonnull
    public final OAuthAccessTokenId getAccessToken() {
        return this._accessToken;
    }

    @Nonnull
    public final DateTime getAccessTokenExpiry() {
        return this._accessTokenExpiry;
    }

    @CheckForNull
    public final OAuthRefreshTokenId getRefreshToken() {
        return this._refreshToken;
    }

    @CheckForNull
    public final DateTime getRefreshTokenExpiry() {
        return this._refreshTokenExpiry;
    }

    @Nonnull
    public final OAuthClientId getClientId() {
        return this._clientId;
    }

    @Nonnull
    public final ImmutableSet<String> getScope() {
        return this._scope;
    }

    @Nonnull
    public final String getGrantType() {
        return this._grantType;
    }

    @CheckForNull
    public final PersonId getPersonId() {
        return this._personId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accessToken", (Object)this._accessToken).add("accessTokenExpiry", (Object)this._accessTokenExpiry).add("refreshToken", (Object)this._refreshToken).add("refreshTokenExpiry", (Object)this._refreshTokenExpiry).add("clientId", (Object)this._clientId).add("scope", this._scope).add("grantType", (Object)this._grantType).add("personId", (Object)this._personId).toString();
    }

    public static class IsFromClientFilter
    extends NullIsFalsePredicate<OAuthToken> {
        private final Set<OAuthClientId> _clientIds;

        public IsFromClientFilter(@Nonnull Set<OAuthClientId> clientIds) {
            this._clientIds = clientIds;
        }

        @Override
        protected boolean applySafe(OAuthToken input) {
            return this._clientIds.contains(input.getClientId());
        }
    }
}

