/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.oauth.business.server.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.security.oauth.business.server.model.OAuthAuthority;
import de.justsoftware.onx.security.oauth.business.server.model.OAuthClientId;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.provider.ClientDetails;

@ParametersAreNonnullByDefault
public class OAuthClient
implements ClientDetails {
    public static final Function<OAuthClient, OAuthClientId> TO_ID = new NullPermeableFunction<OAuthClient, OAuthClientId>(){

        @Override
        public OAuthClientId applySafe(OAuthClient client) {
            return client.getId();
        }
    };
    private static final long serialVersionUID = 1L;
    private final OAuthClientId _clientId;
    private final String _clientSecret;
    private final ImmutableSet<String> _scope;
    private final ImmutableSet<String> _authorizedGrantTypes;
    private final ImmutableSet<OAuthAuthority> _authorities;
    private final Integer _accessTokenValiditySeconds;
    private final Integer _refreshTokenValiditySeconds;
    private final ImmutableSet<String> _autoApprovedScopes;
    private final ImmutableSet<String> _registeredRedirectUri;

    public OAuthClient(OAuthClientId clientId, @Nullable String clientSecret, ImmutableSet<String> scope, ImmutableSet<String> authorizedGrantTypes, ImmutableSet<OAuthAuthority> authorities, @Nullable Integer accessTokenValiditySeconds, @Nullable Integer refreshTokenValiditySeconds, ImmutableSet<String> autoApprovedScopes, ImmutableSet<String> registeredRedirectUri) {
        this._clientId = clientId;
        this._clientSecret = clientSecret;
        this._scope = scope;
        this._authorizedGrantTypes = authorizedGrantTypes;
        this._authorities = authorities;
        this._refreshTokenValiditySeconds = refreshTokenValiditySeconds;
        this._accessTokenValiditySeconds = accessTokenValiditySeconds;
        this._autoApprovedScopes = autoApprovedScopes;
        this._registeredRedirectUri = registeredRedirectUri;
    }

    @Nonnull
    public OAuthClientId getId() {
        return this._clientId;
    }

    public String getClientId() {
        return this._clientId.toString();
    }

    public Set<String> getResourceIds() {
        return ImmutableSet.of();
    }

    public boolean isSecretRequired() {
        return !StringUtil.isBlank(this.getClientSecret());
    }

    public String getClientSecret() {
        return this._clientSecret;
    }

    public boolean isScoped() {
        return !this.getScope().isEmpty();
    }

    public Set<String> getScope() {
        return this._scope;
    }

    public Set<String> getAuthorizedGrantTypes() {
        return this._authorizedGrantTypes;
    }

    public Set<String> getRegisteredRedirectUri() {
        return this._registeredRedirectUri;
    }

    public Collection<GrantedAuthority> getAuthorities() {
        return FluentIterable.from(this._authorities).filter(GrantedAuthority.class).toSet();
    }

    public Integer getAccessTokenValiditySeconds() {
        return this._accessTokenValiditySeconds;
    }

    public Integer getRefreshTokenValiditySeconds() {
        return this._refreshTokenValiditySeconds;
    }

    public boolean isAutoApprove(String scope) {
        return this._autoApprovedScopes.isEmpty() || this._autoApprovedScopes.contains((Object)scope);
    }

    public Map<String, Object> getAdditionalInformation() {
        return ImmutableMap.of();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("clientId", (Object)this._clientId).add("clientSecret", (Object)(this.isSecretRequired() ? "*******" : "no secret")).add("scope", this.isScoped() ? this._scope : "not scoped").add("authorizedGrantTypes", this._authorizedGrantTypes).add("authorities", this._authorities).add("accessTokenValiditySeconds", (Object)this._accessTokenValiditySeconds).add("refreshTokenValiditySeconds", (Object)this._refreshTokenValiditySeconds).add("registeredRedirectUri", this._registeredRedirectUri).toString();
    }
}

