/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.oauth.business.impl;

import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.events.PersonBlockedStatusChangedEvent;
import de.justsoftware.onx.events.PersonDeactivatedEvent;
import de.justsoftware.onx.security.oauth.business.OAuthTokenReadDataService;
import de.justsoftware.onx.security.oauth.business.OAuthTokenService;
import de.justsoftware.onx.security.oauth.business.OAuthTokenWriteDataService;
import de.justsoftware.onx.security.oauth.business.server.model.OAuthAccessTokenId;
import de.justsoftware.onx.security.oauth.business.server.model.OAuthClientId;
import de.justsoftware.onx.security.oauth.business.server.model.OAuthToken;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class OAuthTokenServiceImpl
implements ServerEventHandler,
OAuthTokenService {
    private static final Logger LOG = LoggerFactory.getLogger(OAuthTokenServiceImpl.class);
    private final OAuthTokenReadDataService _tokenReadDataService;
    private final OAuthTokenWriteDataService _tokenWriteDataService;

    @Autowired
    public OAuthTokenServiceImpl(OAuthTokenReadDataService tokenReadDataService, OAuthTokenWriteDataService tokenWriteDataService) {
        this._tokenReadDataService = tokenReadDataService;
        this._tokenWriteDataService = tokenWriteDataService;
    }

    @Nonnull
    private ImmutableSet<PersonId> getPersonIds(Iterable<? extends GlobalId> parentIds) {
        return FluentIterable.from(parentIds).filter(ProfileId.class).transform(ProfileId.TO_PERSON_ID).toSet();
    }

    @Nonnull
    private FluentIterable<OAuthToken> getToken(ImmutableSet<PersonId> personIds) {
        return FluentIterable.from((Iterable)Multimaps.filterKeys(this._tokenReadDataService.getTokensByPersonId((Set<PersonId>)personIds), (Predicate)Predicates.in(personIds)).values()).filter(Predicates.notNull());
    }

    @Nonnull
    private FluentIterable<OAuthToken> getToken(PersonId personId) {
        return this.getToken((ImmutableSet<PersonId>)ImmutableSet.of((Object)personId));
    }

    @Nonnull
    private FluentIterable<OAuthToken> getToken(PersonId personId, Set<OAuthClientId> clientIds) {
        return this.getToken(personId).filter((Predicate)new OAuthToken.IsFromClientFilter(clientIds));
    }

    private void deleteToken(FluentIterable<OAuthToken> tokenIterable) {
        this._tokenWriteDataService.removeTokensByAccessTokenId((Set<OAuthAccessTokenId>)tokenIterable.transform(OAuthToken.TO_ACCESS_TOKEN_ID).toSet());
    }

    @Override
    public long countAccessTokensByPersonId(PersonId personId) {
        return this._tokenReadDataService.countToken(personId);
    }

    @Override
    public void deleteAccessTokensByPersonId(PersonId personId) {
        this.deleteToken(this.getToken(personId));
    }

    @Override
    public long countAccessTokensByPersonIdWithClientId(PersonId personId, Set<OAuthClientId> clientIds) {
        return this._tokenReadDataService.countToken(personId, clientIds);
    }

    @Override
    public void deleteAccessTokensByPersonIdWithClientId(PersonId personId, Set<OAuthClientId> clientIds) {
        this.deleteToken(this.getToken(personId, clientIds));
    }

    @Subscribe
    public void onPersonWasBlocked(PersonBlockedStatusChangedEvent event) {
        if (event.isBlocked()) {
            try {
                this.deleteAccessTokensByPersonId(event.getPersonId());
            }
            catch (InvalidIdServiceException iise) {
                LOG.error("Can't cleanup oauth token for blocked person, no username is resolvable", (Throwable)iise);
            }
        }
    }

    @Subscribe
    public void onPersonWasDeactivated(PersonDeactivatedEvent event) {
        try {
            this.deleteAccessTokensByPersonId(event.getPersonId());
        }
        catch (InvalidIdServiceException iise) {
            LOG.error("Can't cleanup oauth token for deactivated person, no username is resolvable", (Throwable)iise);
        }
    }
}

