/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.oauth.business.impl;

import com.freiheit.toro.cache.ehcache.EhCacheName;
import com.freiheit.toro.cache.ehcache.EhcacheClient;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import de.justsoftware.onx.common.cache.AbstractMapLoadingCacheAccessor;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.Numbers;
import de.justsoftware.onx.security.oauth.business.OAuthTokenReadDataService;
import de.justsoftware.onx.security.oauth.business.OAuthTokenWriteDataService;
import de.justsoftware.onx.security.oauth.business.server.model.OAuthAccessTokenId;
import de.justsoftware.onx.security.oauth.business.server.model.OAuthClientId;
import de.justsoftware.onx.security.oauth.business.server.model.OAuthRefreshTokenId;
import de.justsoftware.onx.security.oauth.business.server.model.OAuthToken;
import de.justsoftware.onx.security.oauth.integration.persistence.OAuthTokenDAO;
import de.justsoftware.onx.security.oauth.integration.persistence.model.DBOAuthToken;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@ParametersAreNonnullByDefault
public class OAuthTokenReadWriteDataServiceImpl
implements OAuthTokenReadDataService,
OAuthTokenWriteDataService {
    private static final Function<DBOAuthToken, OAuthToken> TO_BUSINESS = new NullPermeableFunction<DBOAuthToken, OAuthToken>(){

        @Override
        protected OAuthToken applySafe(DBOAuthToken input) {
            return new OAuthToken(input.getAccessToken(), input.getAccessTokenExpiry(), input.getRefreshToken(), input.getRefreshTokenExpiry(), input.getClientId(), StringUtils.commaDelimitedListToSet((String)input.getScope()), input.getGrantType(), input.getPersonId());
        }
    };
    private static final Maps.EntryTransformer<PersonId, Iterable<DBOAuthToken>, PersonalOAuthTokenCount> TO_COUNT = new Maps.EntryTransformer<PersonId, Iterable<DBOAuthToken>, PersonalOAuthTokenCount>(){

        public PersonalOAuthTokenCount transformEntry(PersonId key, Iterable<DBOAuthToken> value) {
            HashMap countMap = Maps.newHashMap();
            for (DBOAuthToken token : value) {
                PersonalOAuthTokenCount.increase(countMap, token.getClientId());
            }
            return new PersonalOAuthTokenCount(key, (ImmutableMap<OAuthClientId, Long>)ImmutableMap.copyOf((Map)countMap));
        }
    };
    private final OAuthTokenDAO _tokenDao;
    private final TokenByAccessTokenIdCacheAccessor _tokenbyAccessTokenIdCache;
    private final TokenCountByPersonIdCacheAccessor _tokenCountByPersonIdCache;

    @Autowired
    public OAuthTokenReadWriteDataServiceImpl(OAuthTokenDAO tokenDao, EhcacheClient ehCacheClient) {
        this._tokenDao = tokenDao;
        this._tokenbyAccessTokenIdCache = new TokenByAccessTokenIdCacheAccessor(ehCacheClient, this._tokenDao);
        this._tokenCountByPersonIdCache = new TokenCountByPersonIdCacheAccessor(ehCacheClient, this._tokenDao);
    }

    @Override
    public OAuthToken createToken(OAuthAccessTokenId accessTokenId, DateTime accessTokenExpiry, OAuthRefreshTokenId refreshTokenId, DateTime refreshTokenExpiry, OAuthClientId clientId, Set<String> scope, String grantType, PersonId personId) {
        int rowCount = this._tokenDao.createToken(accessTokenId, accessTokenExpiry, refreshTokenId, refreshTokenExpiry, clientId, StringUtils.collectionToCommaDelimitedString(scope), grantType, personId);
        if (personId != null) {
            this._tokenCountByPersonIdCache.invalidateKey(personId);
        }
        return rowCount == 1 ? this.getTokenByAccessTokenId(accessTokenId) : null;
    }

    @Override
    public OAuthToken getTokenByAccessTokenId(OAuthAccessTokenId id) {
        return (OAuthToken)this.getTokensByAccessTokenId((Set<OAuthAccessTokenId>)ImmutableSet.of((Object)id)).get((Object)id);
    }

    @Override
    public OAuthToken getTokenByRefreshTokenId(OAuthRefreshTokenId id) {
        return (OAuthToken)this.getTokensByRefreshTokenId((Set<OAuthRefreshTokenId>)ImmutableSet.of((Object)id)).get((Object)id);
    }

    @Override
    public ImmutableMap<OAuthAccessTokenId, OAuthToken> getTokensByAccessTokenId(Set<OAuthAccessTokenId> idSet) {
        return this._tokenbyAccessTokenIdCache.getMap(idSet);
    }

    @Override
    public ImmutableMap<OAuthRefreshTokenId, OAuthToken> getTokensByRefreshTokenId(Set<OAuthRefreshTokenId> idSet) {
        return ImmutableMap.copyOf((Map)Maps.transformValues(this._tokenDao.getTokensByRefreshTokenId(idSet), TO_BUSINESS));
    }

    @Override
    public ImmutableListMultimap<PersonId, OAuthToken> getTokensByPersonId(Set<PersonId> idSet) {
        return ImmutableListMultimap.copyOf((Multimap)Multimaps.transformValues(this._tokenDao.getTokensByPersonId(idSet), TO_BUSINESS));
    }

    @Override
    public boolean removeTokenByAccessTokenId(OAuthAccessTokenId accessTokenId) {
        return this.removeTokensByAccessTokenId((Set<OAuthAccessTokenId>)ImmutableSet.of((Object)accessTokenId));
    }

    @Override
    public boolean removeTokensByAccessTokenId(Set<OAuthAccessTokenId> idSet) {
        try {
            boolean bl = this._tokenDao.deleteToken(idSet) == idSet.size();
            return bl;
        }
        finally {
            this._tokenbyAccessTokenIdCache.invalidateKeys(idSet);
            this._tokenCountByPersonIdCache.invalidateAll();
        }
    }

    @Override
    public boolean removeTokenByClientId(OAuthClientId clientId) {
        return this.removeTokenByClientId((Set<OAuthClientId>)ImmutableSet.of((Object)clientId));
    }

    @Override
    public boolean removeTokenByClientId(Set<OAuthClientId> idSet) {
        try {
            boolean bl = this._tokenDao.deleteTokenByClientIds(idSet) > 0;
            return bl;
        }
        finally {
            this._tokenbyAccessTokenIdCache.invalidateAll();
            this._tokenCountByPersonIdCache.invalidateAll();
        }
    }

    @Override
    public void removeExpiredTokens(DateTime now) {
        try {
            this._tokenDao.deleteExpiredAccessTokens(now);
        }
        finally {
            this._tokenbyAccessTokenIdCache.invalidateAll();
            this._tokenCountByPersonIdCache.invalidateAll();
        }
    }

    @Override
    public long countToken(PersonId personId, Set<OAuthClientId> clientIds) {
        PersonalOAuthTokenCount single = (PersonalOAuthTokenCount)this._tokenCountByPersonIdCache.getSingle(personId);
        return single != null ? single.count(clientIds) : 0L;
    }

    @Override
    public long countToken(PersonId personId) {
        PersonalOAuthTokenCount single = (PersonalOAuthTokenCount)this._tokenCountByPersonIdCache.getSingle(personId);
        return single != null ? single.countAll() : 0L;
    }

    @Override
    public boolean markTokenAsExpired(OAuthToken token, DateTime now) {
        DateTime tomorrow = now.plusDays(1);
        DateTime newRefreshExpiry = token.getRefreshTokenExpiry() != null && token.getRefreshTokenExpiry().isAfter((ReadableInstant)tomorrow) ? tomorrow : token.getRefreshTokenExpiry();
        int updated = this._tokenDao.updateTokenExpiry(token.getAccessToken(), now, newRefreshExpiry);
        this._tokenbyAccessTokenIdCache.invalidateKeyAndWait(token.getAccessToken());
        this._tokenCountByPersonIdCache.invalidateAll();
        return updated > 0;
    }

    @ParametersAreNonnullByDefault
    private static final class TokenCountByPersonIdCacheAccessor
    extends AbstractMapLoadingCacheAccessor<OAuthTokenEhCacheName, PersonId, PersonalOAuthTokenCount> {
        private final OAuthTokenDAO _dao;

        private TokenCountByPersonIdCacheAccessor(EhcacheClient ehCacheClient, OAuthTokenDAO dao) {
            super(ehCacheClient, OAuthTokenEhCacheName.COUNT_BY_PERSON_ID);
            this._dao = dao;
        }

        @Override
        protected String keyToString(PersonId key) {
            return key.toString();
        }

        @Override
        protected Map<? extends PersonId, ? extends PersonalOAuthTokenCount> getFromDatabaseMulti(Set<? extends PersonId> inputs) {
            ImmutableListMultimap<PersonId, DBOAuthToken> tokensByPersonId = this._dao.getTokensByPersonId((Set<PersonId>)FluentIterable.from(inputs).filter(PersonId.class).filter(Predicates.notNull()).toSet());
            return Maps.transformEntries((Map)tokensByPersonId.asMap(), TO_COUNT);
        }
    }

    @ParametersAreNonnullByDefault
    private static final class TokenByAccessTokenIdCacheAccessor
    extends AbstractMapLoadingCacheAccessor<OAuthTokenEhCacheName, OAuthAccessTokenId, OAuthToken> {
        private final OAuthTokenDAO _dao;

        private TokenByAccessTokenIdCacheAccessor(EhcacheClient ehCacheClient, OAuthTokenDAO dao) {
            super(ehCacheClient, OAuthTokenEhCacheName.TOKEN_BY_ACCESS_TOKEN);
            this._dao = dao;
        }

        @Override
        protected String keyToString(OAuthAccessTokenId key) {
            return key.getId();
        }

        @Override
        protected Map<? extends OAuthAccessTokenId, ? extends OAuthToken> getFromDatabaseMulti(Set<? extends OAuthAccessTokenId> inputs) {
            return Maps.transformValues(this._dao.getTokensByAccessTokenId((Set<OAuthAccessTokenId>)FluentIterable.from(inputs).filter(OAuthAccessTokenId.class).filter(Predicates.notNull()).toSet()), TO_BUSINESS);
        }
    }

    @ParametersAreNonnullByDefault
    private static final class PersonalOAuthTokenCount {
        private final PersonId _personId;
        private final ImmutableMap<OAuthClientId, Long> _mappedCount;

        public PersonalOAuthTokenCount(PersonId personId, ImmutableMap<OAuthClientId, Long> mappedCount) {
            this._personId = personId;
            this._mappedCount = mappedCount;
        }

        @Nonnull
        public final PersonId getPersonId() {
            return this._personId;
        }

        @Nonnull
        public final ImmutableMap<OAuthClientId, Long> getMappedCount() {
            return this._mappedCount;
        }

        public long countAll() {
            return this.count((Set<OAuthClientId>)this._mappedCount.keySet());
        }

        public long count(Set<OAuthClientId> clients) {
            long result = 0L;
            for (OAuthClientId clientId : clients) {
                result += ((Long)MoreObjects.firstNonNull((Object)((Long)this._mappedCount.get((Object)clientId)), (Object)0L)).longValue();
            }
            return result;
        }

        public static final long count(Map<OAuthClientId, Long> map, OAuthClientId client) {
            return Numbers.longValue(map.get(client));
        }

        public static void increase(Map<OAuthClientId, Long> map, OAuthClientId clientId) {
            long currentCount = PersonalOAuthTokenCount.count(map, clientId);
            map.put(clientId, currentCount + 1L);
        }
    }

    @ParametersAreNonnullByDefault
    public static enum OAuthTokenEhCacheName implements EhCacheName
    {
        TOKEN_BY_ACCESS_TOKEN("OAuthToken.byAccessToken"),
        COUNT_BY_PERSON_ID("OAuthToken.countbyPersonId");

        private final String _prefix;

        private OAuthTokenEhCacheName(String prefix) {
            this._prefix = prefix;
        }

        @Override
        public String getCacheName() {
            return this._prefix;
        }
    }
}

