/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.oauth.business.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.security.oauth.business.OAuthTokenDeletionHandler;
import de.justsoftware.onx.security.oauth.business.OAuthTokenReadDataService;
import de.justsoftware.onx.security.oauth.business.OAuthTokenWriteDataService;
import de.justsoftware.onx.security.oauth.business.server.model.OAuthAccessTokenId;
import de.justsoftware.onx.security.oauth.business.server.model.OAuthToken;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="oauthTokenDeletionHandler")
@ParametersAreNonnullByDefault
public class OAuthTokenDeletionHandlerImpl
implements OAuthTokenDeletionHandler {
    private final OAuthTokenReadDataService _tokenReadDataService;
    private final OAuthTokenWriteDataService _tokenWriteDataService;

    @Autowired
    public OAuthTokenDeletionHandlerImpl(OAuthTokenReadDataService tokenReadDataService, OAuthTokenWriteDataService tokenWriteDataService) {
        this._tokenReadDataService = tokenReadDataService;
        this._tokenWriteDataService = tokenWriteDataService;
    }

    @Override
    public void handleCascadeDelete(Set<? extends ItemId> parentIds, DeletionContext deletionContext) {
        final ImmutableSet personIds = FluentIterable.from(parentIds).filter(ProfileId.class).transform(ProfileId.TO_PERSON_ID).toSet();
        ImmutableSet tokenIds = FluentIterable.from((Iterable)this._tokenReadDataService.getTokensByPersonId((Set<PersonId>)personIds).values()).filter((Predicate)new Predicate<OAuthToken>(){

            public boolean apply(OAuthToken input) {
                PersonId personId = input != null ? input.getPersonId() : null;
                return personId != null && personIds.contains((Object)personId);
            }
        }).transform(OAuthToken.TO_ACCESS_TOKEN_ID).toSet();
        this._tokenWriteDataService.removeTokensByAccessTokenId((Set<OAuthAccessTokenId>)tokenIds);
    }
}

