/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.oauth.business.impl;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.business.ServerUrlUtil;
import de.justsoftware.onx.common.integration.persistence.DAOException;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.security.oauth.InternalOauthClientConfiguration;
import de.justsoftware.onx.security.oauth.business.OAuthClientReadDataService;
import de.justsoftware.onx.security.oauth.business.OAuthClientWriteDataService;
import de.justsoftware.onx.security.oauth.business.OAuthTokenWriteDataService;
import de.justsoftware.onx.security.oauth.business.server.model.OAuthAuthority;
import de.justsoftware.onx.security.oauth.business.server.model.OAuthClient;
import de.justsoftware.onx.security.oauth.business.server.model.OAuthClientId;
import de.justsoftware.onx.zookeeper.OpenIdLoginConfiguration;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.provider.ClientAlreadyExistsException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.ClientRegistrationException;
import org.springframework.security.oauth2.provider.ClientRegistrationService;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.stereotype.Service;

@Primary
@Service
@Lazy(value=false)
@ParametersAreNonnullByDefault
public class OAuthClientServices
implements ClientDetailsService,
ClientRegistrationService,
InitializingBean {
    public static final int INTERNAL_CLIENT_ACCESS_TOKEN_VALIDITY_SECONDS = 3600;
    public static final int LOGIN_CLIENT_ACCESS_TOKEN_VALIDITY_SECONDS = Duration.ofMinutes(1L).toSecondsPart();
    private final OAuthClientReadDataService _clientReadDataService;
    private final OAuthClientWriteDataService _clientWriteDataService;
    private final OAuthTokenWriteDataService _tokenWriteDataService;
    private final PasswordEncoder _passwordEncoder;
    private final InternalOauthClientConfiguration _internalOauthClientConfiguration;
    private final OpenIdLoginConfiguration _openIdLoginConfiguration;
    private final ServerUrlUtil _serverUrlUtil;
    private final int _mobileLoginClientAccessTokenValiditySeconds;
    private final int _mobileLoginClientRefreshTokenValiditySeconds;

    @Autowired
    public OAuthClientServices(OAuthClientReadDataService clientReadDataService, OAuthClientWriteDataService clientWriteDataService, OAuthTokenWriteDataService tokenWriteDataService, PasswordEncoder passwordEncoder, InternalOauthClientConfiguration internalOauthClientConfiguration, OpenIdLoginConfiguration openIdLoginConfiguration, ServerUrlUtil serverUrlUtil, @Value(value="${just.login.mobile.access_token_validity_seconds:28800}") int mobileLoginAccessTokenValidityInSeconds, @Value(value="${just.login.mobile.refresh_token_validity_seconds:15778800}") int mobileLoginRefreshTokenValidityInSeconds) {
        this._clientReadDataService = clientReadDataService;
        this._clientWriteDataService = clientWriteDataService;
        this._tokenWriteDataService = tokenWriteDataService;
        this._passwordEncoder = passwordEncoder;
        this._internalOauthClientConfiguration = internalOauthClientConfiguration;
        this._openIdLoginConfiguration = openIdLoginConfiguration;
        this._serverUrlUtil = serverUrlUtil;
        this._mobileLoginClientAccessTokenValiditySeconds = mobileLoginAccessTokenValidityInSeconds;
        this._mobileLoginClientRefreshTokenValiditySeconds = mobileLoginRefreshTokenValidityInSeconds;
    }

    public void addClientDetails(ClientDetails clientDetails) throws ClientAlreadyExistsException {
        OAuthClientId oAuthClientId = new OAuthClientId(clientDetails);
        try {
            boolean created = this._clientWriteDataService.createClient(oAuthClientId, this.encodeClientSecret(clientDetails.getClientSecret()), (ImmutableSet<String>)ImmutableSet.copyOf((Collection)clientDetails.getScope()), (ImmutableSet<String>)ImmutableSet.copyOf((Collection)clientDetails.getAuthorizedGrantTypes()), (ImmutableSet<OAuthAuthority>)FluentIterable.from((Iterable)clientDetails.getAuthorities()).transform(OAuthAuthority.FROM_GRANTED_AUTHORITY).toSet(), clientDetails.getAccessTokenValiditySeconds(), clientDetails.getRefreshTokenValiditySeconds(), clientDetails.getRegisteredRedirectUri());
            if (!created) {
                throw new ClientAlreadyExistsException("Client by id " + oAuthClientId + " already exists!");
            }
        }
        catch (DAOException daoe) {
            throw new ClientRegistrationException("Client by id " + oAuthClientId + " could not be registered", (Throwable)daoe);
        }
    }

    @CheckForNull
    private String encodeClientSecret(@Nullable String clientSecret) {
        return !StringUtil.isBlank(clientSecret) ? this._passwordEncoder.encode((CharSequence)clientSecret) : null;
    }

    public void updateClientDetails(ClientDetails clientDetails) throws NoSuchClientException {
        OAuthClientId oAuthClientId = new OAuthClientId(clientDetails);
        try {
            boolean updated = this._clientWriteDataService.updateClientById(oAuthClientId, (ImmutableSet<String>)ImmutableSet.copyOf((Collection)clientDetails.getScope()), (ImmutableSet<String>)ImmutableSet.copyOf((Collection)clientDetails.getAuthorizedGrantTypes()), (ImmutableSet<OAuthAuthority>)FluentIterable.from((Iterable)clientDetails.getAuthorities()).transform(OAuthAuthority.FROM_GRANTED_AUTHORITY).toSet(), clientDetails.getAccessTokenValiditySeconds(), clientDetails.getRefreshTokenValiditySeconds(), clientDetails.getRegisteredRedirectUri());
            if (!updated) {
                throw new NoSuchClientException("Client by id " + oAuthClientId + " does not exist!");
            }
        }
        catch (DAOException daoe) {
            throw new ClientRegistrationException("Client by id " + oAuthClientId + " could not be updated!", (Throwable)daoe);
        }
    }

    public void updateClientSecret(String clientId, String secret) throws NoSuchClientException {
        OAuthClientId oAuthClientId = new OAuthClientId(clientId);
        try {
            boolean updated = this._clientWriteDataService.updateClientSecretById(oAuthClientId, this.encodeClientSecret(secret));
            if (!updated) {
                throw new NoSuchClientException("Client by id " + oAuthClientId + " does not exist!");
            }
        }
        catch (DAOException daoe) {
            throw new ClientRegistrationException("Client by id " + oAuthClientId + " could not be updated!", (Throwable)daoe);
        }
    }

    public void removeClientDetails(String clientId) throws NoSuchClientException {
        OAuthClientId oAuthClientId = new OAuthClientId(clientId);
        try {
            this._tokenWriteDataService.removeTokenByClientId(oAuthClientId);
            boolean deleted = this._clientWriteDataService.deleteClientById(oAuthClientId);
            if (!deleted) {
                throw new NoSuchClientException("Client by id " + oAuthClientId + " does not exist!");
            }
        }
        catch (DAOException daoe) {
            throw new ClientRegistrationException("Client by id " + oAuthClientId + " could not be deleted!", (Throwable)daoe);
        }
    }

    public List<ClientDetails> listClientDetails() {
        return FluentIterable.from(this._clientReadDataService.getAllClients()).filter(ClientDetails.class).toList();
    }

    public ClientDetails loadClientByClientId(String clientId) throws ClientRegistrationException {
        OAuthClientId oAuthClientId = new OAuthClientId(clientId);
        OAuthClient result = this._clientReadDataService.getClientById(oAuthClientId);
        if (result == null) {
            throw new NoSuchClientException("No client by id " + oAuthClientId + " known!");
        }
        return result;
    }

    public void afterPropertiesSet() {
        this.updateInternalOauthClientDetails();
    }

    private void updateInternalOauthClientDetails() {
        OAuthClient internalClient = new OAuthClient(new OAuthClientId(this._internalOauthClientConfiguration.getClientId()), this._internalOauthClientConfiguration.getClientCredentials(), (ImmutableSet<String>)ImmutableSet.of((Object)"api"), (ImmutableSet<String>)ImmutableSet.of((Object)"client_credentials"), (ImmutableSet<OAuthAuthority>)ImmutableSet.of((Object)new OAuthAuthority("ROLE_TASK_CREATOR")), 3600, null, (ImmutableSet<String>)ImmutableSet.of(), (ImmutableSet<String>)ImmutableSet.of());
        this.addOrUpdateClient(internalClient);
        if (this._openIdLoginConfiguration.getOpenIdLoginClientId() != null) {
            String redirectUri = String.format("%s/login/oauth2/code/just", this._serverUrlUtil.getSystemDomainPrefix());
            OAuthClient loginClient = new OAuthClient(new OAuthClientId(this._openIdLoginConfiguration.getOpenIdLoginClientId()), this._openIdLoginConfiguration.getOpenIdLoginClientSecret(), (ImmutableSet<String>)ImmutableSet.of((Object)"api"), (ImmutableSet<String>)ImmutableSet.of((Object)"authorization_code"), (ImmutableSet<OAuthAuthority>)ImmutableSet.of((Object)new OAuthAuthority("ROLE_USER")), LOGIN_CLIENT_ACCESS_TOKEN_VALIDITY_SECONDS, null, (ImmutableSet<String>)ImmutableSet.of(), (ImmutableSet<String>)ImmutableSet.of((Object)redirectUri));
            this.addOrUpdateClient(loginClient);
        }
        if (this._openIdLoginConfiguration.getOpenIdLoginMobileClientId() != null) {
            ImmutableSet redirectUris = ImmutableSet.of((Object)"de.justsoftware.mobile.connect://oauth2redirect/", (Object)"de.justsoftware.mobile.social://oauth2redirect/", (Object)"de.justsoftware.mobile.chat://oauth2redirect", (Object)"de.justsoftware.mobile.justsocial://oauth2redirect", (Object)"de.justsoftware.mobile.chat.debug://oauth2redirect", (Object)"de.justsoftware.mobile.justsocial.debug://oauth2redirect", (Object[])new String[0]);
            OAuthClient loginClientMobile = new OAuthClient(new OAuthClientId(this._openIdLoginConfiguration.getOpenIdLoginMobileClientId()), null, (ImmutableSet<String>)ImmutableSet.of((Object)"api"), (ImmutableSet<String>)ImmutableSet.of((Object)"authorization_code", (Object)"refresh_token"), (ImmutableSet<OAuthAuthority>)ImmutableSet.of((Object)new OAuthAuthority("ROLE_USER")), this._mobileLoginClientAccessTokenValiditySeconds, this._mobileLoginClientRefreshTokenValiditySeconds, (ImmutableSet<String>)ImmutableSet.of(), (ImmutableSet<String>)redirectUris);
            this.addOrUpdateClient(loginClientMobile);
        }
    }

    private void addOrUpdateClient(OAuthClient internalClient) {
        if (this._clientReadDataService.getClientById(internalClient.getId()) == null) {
            this.addClientDetails(internalClient);
        } else {
            this.updateClientDetails(internalClient);
            this.updateClientSecret(internalClient.getClientId(), internalClient.getClientSecret());
        }
    }
}

