/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.oauth.business.impl;

import com.freiheit.toro.cache.ehcache.EhCacheName;
import com.freiheit.toro.cache.ehcache.EhcacheClient;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.cache.AbstractMapLoadingCacheAccessor;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.security.oauth.business.OAuthClientReadDataService;
import de.justsoftware.onx.security.oauth.business.OAuthClientWriteDataService;
import de.justsoftware.onx.security.oauth.business.server.model.OAuthAuthority;
import de.justsoftware.onx.security.oauth.business.server.model.OAuthClient;
import de.justsoftware.onx.security.oauth.business.server.model.OAuthClientId;
import de.justsoftware.onx.security.oauth.integration.persistence.OAuthClientDAO;
import de.justsoftware.onx.security.oauth.integration.persistence.model.DBOAuthClient;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@ParametersAreNonnullByDefault
public class OAuthClientReadWriteDataServiceImpl
implements OAuthClientReadDataService,
OAuthClientWriteDataService {
    private static final Function<DBOAuthClient, OAuthClient> DB_TO_BUSINESS = new NullPermeableFunction<DBOAuthClient, OAuthClient>(){

        @Override
        protected OAuthClient applySafe(DBOAuthClient client) {
            return new OAuthClient(client.getClientId(), client.getClientSecret(), OAuthClientReadWriteDataServiceImpl.transformScope(client.getScope()), OAuthClientReadWriteDataServiceImpl.transformAuthorizedGrantTypes(client.getAuthorizedGrantTypes()), OAuthClientReadWriteDataServiceImpl.transformGrantedAuthorities(client.getAuthorities()), client.getAccessTokenValiditySeconds(), client.getRefreshTokenValiditySeconds(), OAuthClientReadWriteDataServiceImpl.transformScope(client.getAutoApprovedScopes()), OAuthClientReadWriteDataServiceImpl.transformUriList(client.getRegisteredRedirectUri()));
        }
    };
    private static final Function<String, String> DECODE_URI = new NullPermeableFunction<String, String>(){

        @Override
        protected String applySafe(String input) {
            try {
                return URLDecoder.decode(input, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
    };
    private final OAuthClientDAO _dao;
    private final OAuthAllClientsCacheAccessor _clientCache;

    @Autowired
    public OAuthClientReadWriteDataServiceImpl(EhcacheClient ehCacheClient, OAuthClientDAO dao) {
        this._dao = dao;
        this._clientCache = new OAuthAllClientsCacheAccessor(ehCacheClient, dao);
    }

    @Override
    public boolean createClient(OAuthClientId clientId, String clientSecret, ImmutableSet<String> scope, ImmutableSet<String> authorizedGrantTypes, ImmutableSet<OAuthAuthority> grantedAuthorities, Integer accessTokenValiditySeconds, Integer refreshTokenValiditySeconds, Set<String> redirectUris) {
        int insertedRows = this._dao.createClient(clientId, clientSecret, OAuthClientReadWriteDataServiceImpl.transformScope(scope), OAuthClientReadWriteDataServiceImpl.transformAuthorizedGrantTypes(authorizedGrantTypes), OAuthClientReadWriteDataServiceImpl.transformGrantedAuthorities(grantedAuthorities), accessTokenValiditySeconds, refreshTokenValiditySeconds, OAuthClientReadWriteDataServiceImpl.transformRedirectUris(redirectUris));
        this._clientCache.invalidateAll();
        return insertedRows == 1;
    }

    @Override
    public boolean updateClientById(OAuthClientId clientId, ImmutableSet<String> scope, ImmutableSet<String> authorizedGrantTypes, ImmutableSet<OAuthAuthority> grantedAuthorities, Integer accessTokenValiditySeconds, Integer refreshTokenValiditySeconds, Set<String> redirectUris) {
        int updatedRows = this._dao.updateClientById(clientId, OAuthClientReadWriteDataServiceImpl.transformScope(scope), OAuthClientReadWriteDataServiceImpl.transformAuthorizedGrantTypes(authorizedGrantTypes), OAuthClientReadWriteDataServiceImpl.transformGrantedAuthorities(grantedAuthorities), accessTokenValiditySeconds, refreshTokenValiditySeconds, OAuthClientReadWriteDataServiceImpl.transformRedirectUris(redirectUris));
        this._clientCache.invalidateAll();
        return updatedRows == 1;
    }

    @Override
    public boolean updateClientSecretById(OAuthClientId clientId, String clientSecret) {
        int updatedRows = this._dao.updateClientSecretById(clientId, clientSecret);
        this._clientCache.invalidateAll();
        return updatedRows == 1;
    }

    @Override
    public boolean deleteClientById(OAuthClientId clientId) {
        ImmutableSet clientsToRemove = ImmutableSet.of((Object)clientId);
        int deletedRows = this._dao.deleteClientsById((Set<OAuthClientId>)clientsToRemove);
        this._clientCache.invalidateAll();
        return clientsToRemove.size() == deletedRows;
    }

    @Override
    public Iterable<OAuthClient> getAllClients() {
        return this._clientCache.getAll().values();
    }

    @Override
    public OAuthClient getClientById(OAuthClientId clientId) {
        return (OAuthClient)this._clientCache.getAll().get((Object)clientId);
    }

    @Nonnull
    public static final ImmutableSet<String> transformScope(@Nullable String scope) {
        return FluentIterable.from((Iterable)StringUtils.commaDelimitedListToSet((String)scope)).toSet();
    }

    @Nonnull
    private static ImmutableSet<String> transformUriList(@Nullable String uriList) {
        return FluentIterable.from((Iterable)StringUtils.commaDelimitedListToSet((String)uriList)).transform(DECODE_URI).toSet();
    }

    @Nonnull
    private static String transformScope(@Nullable Collection<String> scope) {
        return StringUtils.collectionToCommaDelimitedString(scope);
    }

    @Nonnull
    private static ImmutableSet<String> transformAuthorizedGrantTypes(@Nullable String authorizedGrantTypes) {
        return FluentIterable.from((Iterable)StringUtils.commaDelimitedListToSet((String)authorizedGrantTypes)).toSet();
    }

    @Nonnull
    private static String transformAuthorizedGrantTypes(@Nullable Collection<String> authorizedGrantTypes) {
        return StringUtils.collectionToCommaDelimitedString(authorizedGrantTypes);
    }

    @Nonnull
    private static ImmutableSet<OAuthAuthority> transformGrantedAuthorities(@Nullable String grantedAuthorities) {
        return FluentIterable.from((Iterable)StringUtils.commaDelimitedListToSet((String)grantedAuthorities)).transform(OAuthAuthority.FROM_STRING).toSet();
    }

    @Nonnull
    private static String transformGrantedAuthorities(@Nullable Collection<OAuthAuthority> grantedAuthorities) {
        return StringUtils.collectionToCommaDelimitedString(grantedAuthorities);
    }

    @Nullable
    private static String transformRedirectUris(@Nullable Set<String> redirectUris) {
        return CollectionUtil.isEmpty(redirectUris) ? null : StringUtils.collectionToCommaDelimitedString(redirectUris);
    }

    @ParametersAreNonnullByDefault
    private static final class OAuthAllClientsCacheAccessor
    extends AbstractMapLoadingCacheAccessor<OAuthClientEhCacheName, String, ImmutableMap<OAuthClientId, OAuthClient>> {
        private static final String KEY = "ALL_CLIENTS";
        private final OAuthClientDAO _clientDao;

        private OAuthAllClientsCacheAccessor(EhcacheClient ehCacheClient, OAuthClientDAO dao) {
            super(ehCacheClient, OAuthClientEhCacheName.OAUTH_CLIENT);
            this._clientDao = dao;
        }

        @Override
        protected Map<? extends String, ? extends ImmutableMap<OAuthClientId, OAuthClient>> getFromDatabaseMulti(Set<? extends String> inputs) {
            return ImmutableMap.of((Object)KEY, (Object)FluentIterable.from(this._clientDao.getAllClients()).transform(DB_TO_BUSINESS).uniqueIndex(OAuthClient.TO_ID));
        }

        @Override
        protected String keyToString(String key) {
            return key;
        }

        @Nonnull
        public ImmutableMap<OAuthClientId, OAuthClient> getAll() {
            ImmutableMap single = (ImmutableMap)this.getSingle(KEY);
            return single != null ? single : ImmutableMap.of();
        }
    }

    @ParametersAreNonnullByDefault
    public static enum OAuthClientEhCacheName implements EhCacheName
    {
        OAUTH_CLIENT("OAuthClient.allClients");

        private final String _prefix;

        private OAuthClientEhCacheName(String prefix) {
            this._prefix = prefix;
        }

        @Override
        public String getCacheName() {
            return this._prefix;
        }
    }
}

