/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.ldap.userdetails;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.migration.business.impl.DomainResolver;
import de.justsoftware.onx.migration.integration.persistence.PersonImportMappingDAO;
import de.justsoftware.onx.person.business.ExternalPersonAccessor;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.security.ldap.userdetails.JustConnectUserDetailsContextMapper;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ldapExternalPersonAccessor")
public class JustConnectLdapPersonAccessor
implements ExternalPersonAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(JustConnectUserDetailsContextMapper.class);
    private static final String SEPARATOR = "@";
    @Autowired
    private DomainResolver _domainResolver;
    @Autowired
    private PersonService _personService;
    @Autowired
    private PersonImportMappingDAO _importDAO;

    @Override
    public DBPerson getPersonByUsername(String externalId) {
        PersonId personId = this.getPersonIdByExternalId(externalId);
        if (personId == null) {
            LOG.warn("User with LDAP username \"{}\" not known in DB", (Object)externalId);
            return null;
        }
        return this._personService.getPersonById(personId);
    }

    @Override
    public PersonId getPersonIdByExternalId(String externalId) {
        PersonId directMapping = this.getInternalId(externalId);
        if (directMapping != null) {
            return directMapping;
        }
        LOG.info("First check failed to find a JuCo person by its original username {}! Checking now domain component.", (Object)externalId);
        ImmutableList values = ImmutableList.copyOf((Iterable)Splitter.on((String)SEPARATOR).omitEmptyStrings().split((CharSequence)externalId));
        if (values.size() != 2) {
            LOG.info("No domain component is specified! Exiting user mapping.", (Object)externalId);
            return null;
        }
        String externalIdWithDomain = (String)values.get(0) + SEPARATOR + this._domainResolver.getDomain((String)values.get(1)).getName();
        if (externalId.equalsIgnoreCase(externalIdWithDomain)) {
            LOG.info("Original username and username with domain component are the same. No JuCo person found for {}", (Object)externalId);
            return null;
        }
        PersonId byExternalIdWithDomain = this.getInternalId(externalIdWithDomain);
        if (byExternalIdWithDomain == null) {
            LOG.info("Could not find JuCo person for user with domain {}!", (Object)externalIdWithDomain);
        }
        return byExternalIdWithDomain;
    }

    @CheckForNull
    private PersonId getInternalId(@Nullable String externalId) {
        return externalId != null ? this._importDAO.getInternalId(externalId) : null;
    }
}

