/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.ldap.userdetails;

import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.util.StringUtil;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

@ParametersAreNonnullByDefault
public class DomainRemovalUserDetailsServiceAdapter
implements UserDetailsService {
    private static final Logger LOG = LoggerFactory.getLogger(DomainRemovalUserDetailsServiceAdapter.class);
    private final UserDetailsService _delegate;
    private ImmutableSet<String> _domainsToRemove;
    private String _domainSeparator;

    public DomainRemovalUserDetailsServiceAdapter(UserDetailsService delegate) {
        this._delegate = delegate;
        this.setDomainsToRemove((Iterable<String>)ImmutableSet.of());
        this.setDomainSeparator("@");
    }

    public void setDomainToRemove(String domain) {
        this.setDomainsToRemove((Iterable<String>)ImmutableSet.of((Object)domain));
    }

    public void setDomainsToRemove(Iterable<String> domainsToRemove) {
        this._domainsToRemove = FluentIterable.from(domainsToRemove).filter(Objects::nonNull).filter(Predicates.not(String::isEmpty)).transform(String::toLowerCase).toSet();
    }

    @Nonnull
    public ImmutableSet<String> getDomainsToRemove() {
        return this._domainsToRemove;
    }

    public void setDomainSeparator(String domainSeparator) {
        this._domainSeparator = domainSeparator;
    }

    public String getDomainSeparator() {
        return this._domainSeparator;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        if (StringUtil.isEmpty(username)) {
            throw new UsernameNotFoundException("username " + username + " was null or empty");
        }
        List userAndDomain = Splitter.on((String)this._domainSeparator).trimResults().omitEmptyStrings().limit(2).splitToList((CharSequence)username);
        return userAndDomain.size() == 2 ? this.loadUserByUserAndDomain(username, (String)userAndDomain.get(0), (String)userAndDomain.get(1)) : this.loadUserWithDelegate(username, "username has no domain component");
    }

    @Nonnull
    private UserDetails loadUserByUserAndDomain(String originalUsername, String username, String domain) {
        return this._domainsToRemove.contains((Object)domain.toLowerCase()) ? this.loadUserWithDelegate(username, "removed mapped domain component " + domain) : this.loadUserWithDelegate(originalUsername, "domain component " + domain + " not mapped");
    }

    @Nonnull
    private UserDetails loadUserWithDelegate(String username, String debugMessage) {
        LOG.debug(debugMessage + " - try fetching user as " + username);
        return this._delegate.loadUserByUsername(username);
    }
}

