/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.kerberos;

import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.security.service.HasAuthenticationProvider;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.kerberos.authentication.KerberosServiceRequestToken;
import org.springframework.security.kerberos.web.authentication.SpnegoEntryPoint;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.Http403ForbiddenEntryPoint;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;

@ParametersAreNonnullByDefault
public class OptionalSpnegoEntryPoint
implements AuthenticationEntryPoint {
    private final AuthenticationEntryPoint _actualEntryPoint;

    public OptionalSpnegoEntryPoint(AuthenticationManager authenticationManager) {
        this(null, authenticationManager);
    }

    public OptionalSpnegoEntryPoint(@Nullable String forwardUrl, AuthenticationManager authenticationManager) {
        this(forwardUrl, null, authenticationManager);
    }

    public OptionalSpnegoEntryPoint(@Nullable String forwardUrl, @Nullable String loginUrl, AuthenticationManager authenticationManager) {
        this._actualEntryPoint = this.hasKerberosAuthenticationProvider(authenticationManager) ? new SpnegoEntryPoint(forwardUrl) : (StringUtil.isBlank(loginUrl) ? new Http403ForbiddenEntryPoint() : new LoginUrlAuthenticationEntryPoint(loginUrl));
    }

    private boolean hasKerberosAuthenticationProvider(AuthenticationManager authenticationManager) {
        for (AuthenticationProvider provider : this.getProvider(authenticationManager)) {
            if (!provider.supports(KerberosServiceRequestToken.class)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    private Iterable<AuthenticationProvider> getProvider(AuthenticationManager authenticationManager) {
        if (HasAuthenticationProvider.class.isInstance(authenticationManager)) {
            return ((HasAuthenticationProvider)HasAuthenticationProvider.class.cast(authenticationManager)).getProviders();
        }
        if (ProviderManager.class.isInstance(authenticationManager)) {
            return ((ProviderManager)ProviderManager.class.cast(authenticationManager)).getProviders();
        }
        return ImmutableList.of();
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        this._actualEntryPoint.commence(request, response, authException);
    }
}

