/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.jwt;

import de.justsoftware.jwtfilter.keys.JwtKeyLoadingException;
import de.justsoftware.jwtfilter.verifier.JwtVerificationConstraintBuilder;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.person.business.PersonReadDataService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.security.SecurityUtils;
import de.justsoftware.onx.security.model.ExternalLoginAuthenticationToken;
import de.justsoftware.onx.security.model.JustConnectUser;
import de.justsoftware.onx.security.model.JustConnectUserAuthenticationToken;
import de.justsoftware.onx.security.service.JustAuthenticationProvider;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.authentication.AccountStatusUserDetailsChecker;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsChecker;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service(value="externalLoginAuthenticationProvider")
public class ExternalLoginAuthenticationProvider
implements JustAuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalLoginAuthenticationProvider.class);
    private final UserDetailsChecker _userDetailsChecker = new AccountStatusUserDetailsChecker();
    private final JwtVerifier _jwtVerifier;
    private final PersonReadDataService _personReadDataService;

    @Autowired
    public ExternalLoginAuthenticationProvider(@Qualifier(value="encryptedJwtVerifier") JwtVerifier jwtVerifier, PersonReadDataService personReadDataService) {
        this._jwtVerifier = jwtVerifier;
        this._personReadDataService = personReadDataService;
    }

    public boolean supports(Class<?> authentication) {
        return ExternalLoginAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        JwtClaims verifiedJwtClaims = this.getVerifiedJwtClaims(authentication);
        return new JustConnectUserAuthenticationToken(this.getJustConnectUser(verifiedJwtClaims), (String)verifiedJwtClaims.getClaimValue("tenantId"));
    }

    @Nonnull
    private JwtClaims getVerifiedJwtClaims(Authentication authentication) {
        try {
            JwtVerificationConstraintBuilder verifcationConstraints = new JwtVerificationConstraintBuilder().withRequireSubject();
            String token = ((ExternalLoginAuthenticationToken)authentication).getToken();
            JwtClaims claims = this._jwtVerifier.verify(verifcationConstraints, token);
            LOG.debug("JWT token successfully verified");
            return claims;
        }
        catch (JwtKeyLoadingException | ClassCastException | InvalidJwtException ex) {
            LOG.error("Invalid JWT token ", ex);
            throw new InvalidTokenException("Invalid JWT token");
        }
    }

    @Nonnull
    private JustConnectUser getJustConnectUser(JwtClaims jwtClaims) {
        String subject = null;
        try {
            subject = jwtClaims.getSubject();
            PersonId personId = new PersonId(Long.parseLong(subject));
            DBPerson person = this._personReadDataService.getPersonById(personId);
            if (person == null) {
                throw new InvalidTokenException("Invalid JWT, no User for subject id " + personId);
            }
            JustConnectUser justConnectUser = SecurityUtils.getJustConnectUser(person);
            this._userDetailsChecker.check((UserDetails)justConnectUser);
            return justConnectUser;
        }
        catch (NumberFormatException e) {
            throw new InvalidTokenException("Invalid subject in JWT token: " + subject + " - expected a long!", (Throwable)e);
        }
        catch (MalformedClaimException e) {
            throw new InvalidTokenException("Malformed JWT token", (Throwable)e);
        }
    }
}

