/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security;

import com.freiheit.toro.common.shared.model.NotLoggedInException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import de.justsoftware.jwtfilter.JwtAuthenticationToken;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.security.model.JustConnectUser;
import de.justsoftware.onx.security.model.JustConnectUserAuthenticationToken;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.OAuth2Authentication;

@ParametersAreNonnullByDefault
public final class SecurityUtils {
    private SecurityUtils() {
    }

    @CheckForNull
    public static Authentication getAuthenticationOrNull() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    @CheckForNull
    public static PersonId getUserIdOrNull(@Nullable Authentication auth) {
        if (auth == null) {
            return null;
        }
        if (auth instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken token = (JwtAuthenticationToken)auth;
            return ProfileId.parseNonnull(token.getPrincipal().toString()).asPersonId();
        }
        Object principal = auth.getPrincipal();
        if (principal instanceof JustConnectUser) {
            return new PersonId(((JustConnectUser)principal).getId());
        }
        Object details = auth.getDetails();
        if (details instanceof JustConnectUser) {
            return new PersonId(((JustConnectUser)details).getId());
        }
        return null;
    }

    @Nonnull
    public static Optional<TenantId> getTenantId() {
        Authentication auth = SecurityUtils.getAuthenticationOrNull();
        if (auth == null) {
            return Optional.empty();
        }
        if (auth instanceof OAuth2Authentication) {
            return SecurityUtils.parseTenantIdFromAuthentication(((OAuth2Authentication)auth).getUserAuthentication());
        }
        return SecurityUtils.parseTenantIdFromAuthentication(auth);
    }

    @Nonnull
    private static Optional<TenantId> parseTenantIdFromAuthentication(Authentication auth) {
        if (auth instanceof JustConnectUserAuthenticationToken) {
            JustConnectUserAuthenticationToken token = (JustConnectUserAuthenticationToken)auth;
            return Optional.ofNullable(token.getCustomJwtClaims().get((Object)"tenantId")).map(Object::toString).map(TenantId::parse).orElse(Optional.empty());
        }
        return Optional.empty();
    }

    @CheckForNull
    public static JustConnectUser getJustConnectUser(@Nullable Authentication auth) {
        if (auth == null) {
            return null;
        }
        Object principal = auth.getPrincipal();
        if (principal instanceof JustConnectUser) {
            return (JustConnectUser)principal;
        }
        Object details = auth.getDetails();
        if (details instanceof JustConnectUser) {
            return (JustConnectUser)details;
        }
        return null;
    }

    @Nonnull
    public static JustConnectUser getJustConnectUser(DBPerson dbPerson) {
        return new JustConnectUser(dbPerson.getId().getId(), dbPerson.getEmail(), Strings.nullToEmpty((String)dbPerson.getPasswordHash()), dbPerson.isActive(), !dbPerson.isBlocked(), !dbPerson.isDeleted(), dbPerson.isActive());
    }

    @CheckForNull
    public static PersonId getUserIdOrNull() {
        return SecurityUtils.getUserIdOrNull(SecurityUtils.getAuthenticationOrNull());
    }

    public static boolean isAuthenticatedUser() {
        return SecurityUtils.getUserIdOrNull() != null;
    }

    @Nonnull
    public static PersonId getNonnullUserId() throws NotLoggedInException {
        PersonId userId = SecurityUtils.getUserIdOrNull();
        if (userId == null) {
            throw new NotLoggedInException();
        }
        return userId;
    }

    @Nonnull
    public static PersonId getUserId(JustConnectUser justConnectUser) {
        return new PersonId(justConnectUser.getId());
    }

    @VisibleForTesting
    public static void doManualLogin(Authentication authentication) {
        SecurityContextHolder.getContext().setAuthentication(authentication);
    }

    public static void loginToTenant(TenantId tenantId) {
        SecurityContext context = SecurityContextHolder.getContext();
        Authentication auth = context.getAuthentication();
        JustConnectUser justConnectUser = SecurityUtils.getJustConnectUser(auth);
        context.setAuthentication((Authentication)new JustConnectUserAuthenticationToken(justConnectUser, tenantId.asString()));
    }

    @VisibleForTesting
    public static void doManualLogin(@Nullable DBPerson dbPerson) {
        if (dbPerson == null) {
            SecurityContextHolder.clearContext();
        } else {
            JustConnectUser justConnectUser = SecurityUtils.getJustConnectUser(dbPerson);
            UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)dbPerson.getEmail(), (Object)justConnectUser.getPassword(), justConnectUser.getAuthorities());
            token.setDetails((Object)justConnectUser);
            SecurityUtils.doManualLogin((Authentication)token);
        }
    }
}

