/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.secret.business.impl;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterators;
import de.justsoftware.onx.secret.business.SecretKeyName;
import de.justsoftware.onx.secret.business.impl.FilesystemMasterKeyProvider;
import de.justsoftware.onx.secret.business.impl.SecretServiceImpl;
import de.justsoftware.onx.util.server.Base64Util;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.ArrayUtils;
import org.bouncycastle.util.encoders.Hex;

public class ReadSecret {
    private static final String DEFAULT_LOCATION = "/home/justsoftware/justconnect_conf/juco.master.key";

    public static void main(@Nonnull String[] args) throws URISyntaxException {
        if (args.length < 2 || args.length > 4) {
            System.out.println("ReadSecret <keyname> <keyvalue> [<masterkeyfile>]");
            System.out.println("keyname: the keyname as defined in SecretKeyName.java");
            System.out.println("keyvalue: value from database which you will get with select secret_value from secret where secret_key = '<keyname>';");
            System.out.println("masterkeyfile: location of the master key, defaults to \"/home/justsoftware/justconnect_conf/juco.master.key\"");
            return;
        }
        SecretKeyName key = SecretKeyName.valueOf(args[0]);
        String keyValue = args[1];
        FilesystemMasterKeyProvider masterKeyProvider = new FilesystemMasterKeyProvider(args.length == 3 ? args[2] : DEFAULT_LOCATION);
        byte[] masterKey = masterKeyProvider.getMasterKey();
        byte[] decodedKey = SecretServiceImpl.createEncoder(key, masterKey).decode(keyValue).asByteArray();
        System.out.println("Arrays.toString: " + Arrays.toString(decodedKey));
        System.out.println("Base64Util.encode (urlsafe): " + Base64Util.encode(decodedKey));
        System.out.println("Base64Util.encode (normal): " + new Base64(-1, new byte[0], false).encodeToString(decodedKey));
        Iterator hex = Iterators.transform((Iterator)Iterators.forArray((Object[])ArrayUtils.toObject((byte[])decodedKey)), (Function)new Function<Byte, String>(){

            public String apply(Byte input) {
                return input != null ? Hex.toHexString((byte[])new byte[]{input}) : null;
            }
        });
        System.out.println("C Style: [0x" + Joiner.on((String)",0x").join(hex) + "]");
        System.out.println("Hex.encodeHex: " + Hex.toHexString((byte[])decodedKey));
    }
}

