/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.secret.business;

import com.google.common.base.Charsets;
import de.justsoftware.onx.secret.business.SecretKey;
import de.justsoftware.onx.util.server.SaltKeyProvider;
import de.justsoftware.onx.util.server.SecureRandomUtil;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.commons.lang.ArrayUtils;

public final class SaltSecretKey
implements SecretKey,
SaltKeyProvider {
    private final byte[] _salt;

    public SaltSecretKey(@Nonnull byte[] salt) {
        this._salt = (byte[])salt.clone();
    }

    @Nonnull
    public static SaltSecretKey generate() {
        return new SaltSecretKey(SecureRandomUtil.randomBytes(16));
    }

    @Override
    public byte[] asByteArray() {
        return (byte[])this._salt.clone();
    }

    @Override
    public byte[] saltString(String s) {
        return this.saltBytes(s.getBytes(Charsets.UTF_8));
    }

    @Override
    public byte[] saltBytes(byte[] bytes) {
        return ArrayUtils.addAll((byte[])bytes, (byte[])this._salt);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof SaltSecretKey && Arrays.equals(this._salt, ((SaltSecretKey)obj)._salt);
    }

    public int hashCode() {
        return Arrays.hashCode(this._salt);
    }
}

