/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.shared.server.model;

import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.searchnew.business.CommonSearchFields;
import de.justsoftware.onx.searchnew.business.SearchField;
import de.justsoftware.onx.searchnew.business.SearchFieldVisitor;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class MultiWikiSearchFieldModel
implements SearchField {
    private final String _fieldname;

    public MultiWikiSearchFieldModel(@Nonnull String fieldname) {
        this._fieldname = fieldname;
    }

    @Nonnull
    public static ImmutableList<MultiWikiSearchFieldModel> createMultiwikiSearchFields(Collection<String> roles) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (String role : roles) {
            result.add((Object)new MultiWikiSearchFieldModel(MultiWikiSearchFieldModel.fieldNameFromRole(role)));
        }
        return result.build();
    }

    public static String fieldNameFromRole(String role) {
        return "multiwiki_for_role_" + role.replaceAll(",", "_");
    }

    @Override
    public String getFieldName() {
        return this._fieldname;
    }

    @Override
    public Float getBoostFactor() {
        return CommonSearchFields.CONTENT.getBoostFactor();
    }

    @Override
    public <T> T accept(SearchFieldVisitor<T> v) {
        return v.visitMultiWikiSection(this);
    }

    public String toString() {
        return this.getFieldName();
    }

    @Override
    public boolean isQueryField() {
        return true;
    }
}

