/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.shared.server.model;

import com.google.common.base.MoreObjects;
import de.justsoftware.onx.searchnew.business.SearchField;
import de.justsoftware.onx.searchnew.business.SearchFieldVisitor;

public class DynamicSearchFieldModel
implements SearchField {
    private static final Float DYNAMIC_PROFILE_FIELD_BOOST_FACTOR = Float.valueOf(6.0f);
    private final String _fieldName;

    public DynamicSearchFieldModel(String fieldName) {
        this._fieldName = fieldName;
    }

    @Override
    public String getFieldName() {
        return "profile_dynamic_" + this._fieldName;
    }

    @Override
    public Float getBoostFactor() {
        return DYNAMIC_PROFILE_FIELD_BOOST_FACTOR;
    }

    @Override
    public <T> T accept(SearchFieldVisitor<T> v) {
        return v.visitDynamicAttributes(this);
    }

    @Override
    public boolean isQueryField() {
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("fieldName", (Object)this._fieldName).toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DynamicSearchFieldModel) {
            DynamicSearchFieldModel other = (DynamicSearchFieldModel)obj;
            return this.getFieldName().equals(other.getFieldName());
        }
        return false;
    }

    public int hashCode() {
        return this.getFieldName().hashCode();
    }
}

