/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.shared.server.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeId;
import de.justsoftware.onx.common.shared.model.attributes.EntityDynamicAttributesUtil;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.searchnew.business.CommonSearchFields;
import de.justsoftware.onx.searchnew.business.SearchField;
import de.justsoftware.onx.searchnew.business.SearchFieldVisitor;
import javax.annotation.Nonnull;

public class DynamicEntityAttributeSearchFieldModel
implements SearchField {
    private final DynamicAttributeId _dynamicAttributeId;
    private final EntityType _entityType;

    public DynamicEntityAttributeSearchFieldModel(@Nonnull DynamicAttributeId dynamicAttributeId, @Nonnull EntityType entityType) {
        this._entityType = entityType;
        this._dynamicAttributeId = dynamicAttributeId;
    }

    @Override
    public String getFieldName() {
        return EntityDynamicAttributesUtil.toSearchFieldName(this._dynamicAttributeId, this._entityType);
    }

    @Override
    public Float getBoostFactor() {
        return CommonSearchFields.CONTENT.getBoostFactor();
    }

    @Override
    public boolean isQueryField() {
        return true;
    }

    @Override
    public <T> T accept(SearchFieldVisitor<T> v) {
        return v.visitDynamicEntityAttributes(this);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this._dynamicAttributeId, this._entityType});
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof DynamicEntityAttributeSearchFieldModel && Objects.equal((Object)this._dynamicAttributeId, (Object)((DynamicEntityAttributeSearchFieldModel)obj)._dynamicAttributeId) && Objects.equal((Object)this._entityType, (Object)((DynamicEntityAttributeSearchFieldModel)obj)._entityType);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("dynamicAttributeId", (Object)this._dynamicAttributeId).add("entityType", (Object)this._entityType).toString();
    }
}

