/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.shared.server.model;

import com.freiheit.toro.common.shared.util.ObjectUtil;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.container.shared.model.Identifiable;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.SearchableId;
import de.justsoftware.onx.searchnew.business.model.SearchIndexType;
import de.justsoftware.onx.searchnew.shared.server.model.SearchIndexQueueEntryId;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.util.Date;
import javax.annotation.Nonnull;

public class DBSearchIndexQueueEntry
implements Identifiable<SearchIndexQueueEntryId> {
    public static final Function<DBSearchIndexQueueEntry, ItemId> TO_ITEM_ID = new NullPermeableFunction<DBSearchIndexQueueEntry, ItemId>(){

        @Override
        protected ItemId applySafe(DBSearchIndexQueueEntry input) {
            return input.getItemId();
        }
    };
    public static final Function<DBSearchIndexQueueEntry, SearchIndexQueueEntryId> TO_ID = new NullPermeableFunction<DBSearchIndexQueueEntry, SearchIndexQueueEntryId>(){

        @Override
        public SearchIndexQueueEntryId applySafe(DBSearchIndexQueueEntry input) {
            return input.getId();
        }
    };
    public static final Function<DBSearchIndexQueueEntry, SearchIndexType> TO_INDEX_TYPE = new NullPermeableFunction<DBSearchIndexQueueEntry, SearchIndexType>(){

        @Override
        public SearchIndexType applySafe(DBSearchIndexQueueEntry input) {
            return input.getIndexType();
        }
    };
    private SearchIndexQueueEntryId _id;
    private Date _createdAt;
    private ItemId _itemId;
    private SearchIndexType _indexType;

    @Deprecated
    public DBSearchIndexQueueEntry() {
    }

    public DBSearchIndexQueueEntry(@Nonnull ItemId itemId, @Nonnull Date createdAt, @Nonnull SearchIndexType indexType) {
        this._itemId = itemId;
        this._createdAt = new Date(createdAt.getTime());
        this._indexType = indexType;
    }

    @Override
    public SearchIndexQueueEntryId getId() {
        return this._id;
    }

    public void setId(@Nonnull SearchIndexQueueEntryId id) {
        this._id = id;
    }

    @Nonnull
    public Date getCreatedAt() {
        return new Date(this._createdAt.getTime());
    }

    public void setCreatedAt(@Nonnull Date createdAt) {
        this._createdAt = new Date(createdAt.getTime());
    }

    @Nonnull
    public ItemId getItemId() {
        return this._itemId;
    }

    @Nonnull
    public SearchableId getSearchableId() {
        return ObjectUtil.checkNotNull(SearchableId.fromItemId(this._itemId));
    }

    public void setItemId(@Nonnull ItemId itemId) {
        this._itemId = itemId;
    }

    @Nonnull
    public SearchIndexType getIndexType() {
        return this._indexType;
    }

    public void setIndexType(@Nonnull SearchIndexType indexType) {
        this._indexType = indexType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        DBSearchIndexQueueEntry other = (DBSearchIndexQueueEntry)obj;
        return Objects.equal((Object)this._itemId, (Object)other._itemId) && Objects.equal((Object)((Object)this._indexType), (Object)((Object)other._indexType));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this._itemId, this._indexType});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("createdAt", (Object)this._createdAt).add("itemId", (Object)this._itemId).add("indexType", (Object)this._indexType).toString();
    }

    @Nonnull
    public static final ImmutableSet<DBSearchIndexQueueEntry> fromItemIds(@Nonnull Iterable<? extends ItemId> ids, SearchIndexType ... indexTypes) {
        FluentIterable types = FluentIterable.from((Object[])indexTypes);
        return FluentIterable.from(ids).transformAndConcat(id -> types.transform(indexType -> new DBSearchIndexQueueEntry((ItemId)id, new Date(), (SearchIndexType)((Object)((Object)indexType))))).filter(Predicates.notNull()).toSet();
    }
}

