/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.shared.server.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import de.justsoftware.onx.container.shared.model.AbstractUUIDBasedItemId;
import de.justsoftware.onx.container.shared.model.Identifiable;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.searchnew.business.model.ConversationIndexType;
import de.justsoftware.onx.searchnew.shared.server.model.ConversationSearchIndexQueueEntryId;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public class DBConversationSearchIndexQueueEntry
implements Identifiable<ConversationSearchIndexQueueEntryId> {
    public static final Function<DBConversationSearchIndexQueueEntry, ConversationSearchIndexQueueEntryId> TO_ID = new NullPermeableFunction<DBConversationSearchIndexQueueEntry, ConversationSearchIndexQueueEntryId>(){

        @Override
        protected ConversationSearchIndexQueueEntryId applySafe(DBConversationSearchIndexQueueEntry input) {
            return input.getId();
        }
    };
    public static final Function<DBConversationSearchIndexQueueEntry, AbstractUUIDBasedItemId> TO_ITEM_ID = new NullPermeableFunction<DBConversationSearchIndexQueueEntry, AbstractUUIDBasedItemId>(){

        @Override
        protected AbstractUUIDBasedItemId applySafe(DBConversationSearchIndexQueueEntry input) {
            return input.toItemId();
        }
    };
    private ConversationSearchIndexQueueEntryId _id;
    private DateTime _createdAt;
    private UUID _itemId;
    private ItemType _itemType;
    private ConversationIndexType _indexType;

    @Deprecated
    public DBConversationSearchIndexQueueEntry() {
    }

    public DBConversationSearchIndexQueueEntry(AbstractUUIDBasedItemId itemId, DateTime createdAt, ConversationIndexType indexType) {
        this._id = ConversationSearchIndexQueueEntryId.random();
        this._itemId = itemId.getId();
        this._itemType = itemId.getType();
        this._createdAt = createdAt;
        this._indexType = indexType;
    }

    @Override
    public ConversationSearchIndexQueueEntryId getId() {
        return this._id;
    }

    public void setId(ConversationSearchIndexQueueEntryId id) {
        this._id = id;
    }

    @Nonnull
    public DateTime getCreatedAt() {
        return this._createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this._createdAt = createdAt;
    }

    @Nonnull
    public UUID getItemId() {
        return this._itemId;
    }

    public void setItemId(UUID itemId) {
        this._itemId = itemId;
    }

    @Nonnull
    public ItemType getItemType() {
        return this._itemType;
    }

    public void setItemType(ItemType itemType) {
        this._itemType = itemType;
    }

    @Nonnull
    public AbstractUUIDBasedItemId toItemId() {
        return AbstractUUIDBasedItemId.create(this._itemId, this._itemType);
    }

    @Nonnull
    public ConversationIndexType getIndexType() {
        return this._indexType;
    }

    public void setIndexType(ConversationIndexType indexType) {
        this._indexType = indexType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        DBConversationSearchIndexQueueEntry other = (DBConversationSearchIndexQueueEntry)obj;
        return Objects.equal((Object)this._itemId, (Object)other._itemId) && Objects.equal((Object)this._itemType, (Object)other._itemType) && Objects.equal((Object)((Object)this._indexType), (Object)((Object)other._indexType));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this._itemId, this._indexType});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("createdAt", (Object)this._createdAt).add("itemId", (Object)this._itemId).add("itemType", (Object)this._itemType).add("indexType", (Object)this._indexType).toString();
    }
}

