/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.shared.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.container.shared.model.EntityStatusId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.searchnew.shared.model.ArchiveSubFilter;
import de.justsoftware.onx.searchnew.shared.model.EntityStatusSubFilter;
import de.justsoftware.onx.searchnew.shared.model.FilterTypeVisitor;
import de.justsoftware.onx.searchnew.shared.model.SearchConfigurationProvider;
import de.justsoftware.onx.searchnew.shared.model.SubFilter;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class SubfilterForFilterTypeVisitor
implements FilterTypeVisitor<ImmutableSet<? extends SubFilter>> {
    private final SearchConfigurationProvider _config;

    public SubfilterForFilterTypeVisitor(SearchConfigurationProvider config) {
        this._config = config;
    }

    @Nonnull
    private ImmutableSet<? extends SubFilter> nonArchivedWhenNecessary() {
        return this._config.isShowArchivedSearchFilterAnyEntityType() ? ImmutableSet.of((Object)ArchiveSubFilter.NON_ARCHIVED) : ImmutableSet.of();
    }

    @Override
    public ImmutableSet<? extends SubFilter> visitDefault() {
        return this.nonArchivedWhenNecessary();
    }

    @Override
    public ImmutableSet<? extends SubFilter> visitEntity(EntityType entityType) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        if (this._config.isShowEntityStatusSearchFilter(entityType)) {
            ImmutableSetMultimap<Boolean, EntityStatusId> entityStatusByArchivedFlag = this._config.getEntityStatusByArchivedFlag(entityType);
            boolean hasArchivedStatus = !entityStatusByArchivedFlag.get((Object)Boolean.TRUE).isEmpty();
            ImmutableSet nonArchivedStatus = entityStatusByArchivedFlag.get((Object)Boolean.FALSE);
            if (hasArchivedStatus && !nonArchivedStatus.isEmpty()) {
                result.add((Object)new EntityStatusSubFilter(entityType, (ImmutableSet<EntityStatusId>)nonArchivedStatus));
            }
        }
        if (this._config.isShowArchivedSearchFilter(entityType)) {
            result.add((Object)ArchiveSubFilter.NON_ARCHIVED);
        }
        return result.build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("config", (Object)this._config).toString();
    }

    @Override
    public ImmutableSet<? extends SubFilter> visitDocuments() {
        return this._config.useDefaultArchivedFilterForDocuments() ? this.nonArchivedWhenNecessary() : ImmutableSet.of();
    }
}

