/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.shared.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeId;
import de.justsoftware.onx.searchnew.shared.model.ArchiveSubFilter;
import de.justsoftware.onx.searchnew.shared.model.BlockSubFilter;
import de.justsoftware.onx.searchnew.shared.model.ChatUserSubFilter;
import de.justsoftware.onx.searchnew.shared.model.CoadminSubFilter;
import de.justsoftware.onx.searchnew.shared.model.DateSubFilter;
import de.justsoftware.onx.searchnew.shared.model.DocumentFileTypeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.DriveDocumentTypeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.DriveFileTypeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.EntityDynamicAttributeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.EntityMemberSubFilter;
import de.justsoftware.onx.searchnew.shared.model.EntityStatusSubFilter;
import de.justsoftware.onx.searchnew.shared.model.InheritAdminSubFilter;
import de.justsoftware.onx.searchnew.shared.model.InheritMemberSubFilter;
import de.justsoftware.onx.searchnew.shared.model.ModificationDateSubFilter;
import de.justsoftware.onx.searchnew.shared.model.OrSubFilter;
import de.justsoftware.onx.searchnew.shared.model.PersonIdSubFilter;
import de.justsoftware.onx.searchnew.shared.model.PersonRoleSubFilter;
import de.justsoftware.onx.searchnew.shared.model.ProfileAttributeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.PublicationDateFilter;
import de.justsoftware.onx.searchnew.shared.model.StartAndEndDateSubFilter;
import de.justsoftware.onx.searchnew.shared.model.StartDateSubFilter;
import de.justsoftware.onx.searchnew.shared.model.SubFilter;
import de.justsoftware.onx.searchnew.shared.model.SubFilterVisitor;
import de.justsoftware.onx.searchnew.shared.model.TagSubFilter;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class SubFilterSelector {
    private boolean _selectDateFilter;
    private boolean _selectPersonRoleFilter;
    private Predicate<? super String> _selectProfileAttributeFilter;
    private boolean _selectStartAndEndDateFilter;
    private boolean _selectStartDateFilter;
    private boolean _selectPersonIdFilter;
    private final boolean _selectMemberFilter;
    private final boolean _selectInheritMemberFilter;
    private final boolean _selectInheritAdminFilter;
    private boolean _selectDocumentFileTypeFilter;
    private boolean _selectModificationDateFilter;
    private final boolean _selectCoadminSubFilter;
    private Predicate<? super DynamicAttributeId> _selectEntityDynAttFilter;
    private boolean _selectArchiveSubFilter;
    private boolean _selectBlockedSubFilter;
    private boolean _selectChatUserSubFilter;
    private boolean _selectEntityStatusFilter;
    private boolean _selectTagFilter;
    private boolean _selectConversationTypeFilter;
    private boolean _selectDriveDocumentTypeFilter;

    private SubFilterSelector(boolean initial) {
        this._selectDateFilter = initial;
        this._selectProfileAttributeFilter = initial ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
        this._selectStartAndEndDateFilter = initial;
        this._selectStartDateFilter = initial;
        this._selectPersonRoleFilter = initial;
        this._selectPersonIdFilter = initial;
        this._selectMemberFilter = initial;
        this._selectInheritMemberFilter = initial;
        this._selectInheritAdminFilter = initial;
        this._selectDocumentFileTypeFilter = initial;
        this._selectModificationDateFilter = initial;
        this._selectEntityDynAttFilter = initial ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
        this._selectCoadminSubFilter = initial;
        this._selectArchiveSubFilter = initial;
        this._selectBlockedSubFilter = initial;
        this._selectChatUserSubFilter = initial;
        this._selectEntityStatusFilter = initial;
        this._selectTagFilter = initial;
        this._selectConversationTypeFilter = initial;
        this._selectDriveDocumentTypeFilter = initial;
    }

    @Nonnull
    public static SubFilterSelector selectAll() {
        return new SubFilterSelector(true);
    }

    @Nonnull
    public static SubFilterSelector skipAll() {
        return new SubFilterSelector(false);
    }

    @Nonnull
    public SubFilterSelector selectDateSubFilter() {
        this._selectDateFilter = true;
        return this;
    }

    @Nonnull
    public SubFilterSelector selectPersonRoleSubFilter() {
        this._selectPersonRoleFilter = true;
        return this;
    }

    @Nonnull
    public SubFilterSelector selectProfileAttributeSubFilter(@Nonnull String name) {
        this._selectProfileAttributeFilter = Predicates.equalTo((Object)name);
        return this;
    }

    @Nonnull
    public SubFilterSelector selectPersonIdySubFilter() {
        this._selectPersonIdFilter = true;
        return this;
    }

    @Nonnull
    public SubFilterSelector selectStartAndEndDateSubFilter() {
        this._selectStartAndEndDateFilter = true;
        return this;
    }

    @Nonnull
    public SubFilterSelector selectStartDateSubFilter() {
        this._selectStartDateFilter = true;
        return this;
    }

    @Nonnull
    public SubFilterSelector selectDocumentFileTypeSubFilter() {
        this._selectDocumentFileTypeFilter = true;
        return this;
    }

    @Nonnull
    public SubFilterSelector selectModificationDateSubFilter() {
        this._selectModificationDateFilter = true;
        return this;
    }

    @Nonnull
    public SubFilterSelector selectEntityDynamicAttributeSubFilter(@Nonnull DynamicAttributeId id) {
        this._selectEntityDynAttFilter = Predicates.equalTo((Object)id);
        return this;
    }

    @Nonnull
    public SubFilterSelector selectArchiveSubFilter() {
        this._selectArchiveSubFilter = true;
        return this;
    }

    @Nonnull
    public SubFilterSelector selectBlockedSubFilter() {
        this._selectBlockedSubFilter = true;
        return this;
    }

    @Nonnull
    public SubFilterSelector selectEntityStatusSubFilter() {
        this._selectEntityStatusFilter = true;
        return this;
    }

    @Nonnull
    public SubFilterSelector selectTagSubFilter() {
        this._selectTagFilter = true;
        return this;
    }

    @Nonnull
    public SubFilterSelector selectConversationTypeSubFilter() {
        this._selectConversationTypeFilter = true;
        return this;
    }

    @Nonnull
    public SubFilterSelector skipDateSubFilter() {
        this._selectDateFilter = false;
        return this;
    }

    @Nonnull
    public SubFilterSelector skipPersonRoleSubFilter() {
        this._selectPersonRoleFilter = false;
        return this;
    }

    @Nonnull
    public SubFilterSelector skipProfileAttributeSubFilter(@Nonnull String name) {
        this._selectProfileAttributeFilter = Predicates.not((Predicate)Predicates.equalTo((Object)name));
        return this;
    }

    @Nonnull
    public SubFilterSelector skipPersonIdySubFilter() {
        this._selectPersonIdFilter = false;
        return this;
    }

    @Nonnull
    public SubFilterSelector skipStartAndEndDateSubFilter() {
        this._selectStartAndEndDateFilter = false;
        return this;
    }

    @Nonnull
    public SubFilterSelector skipDocumentFileTypeSubFilter() {
        this._selectDocumentFileTypeFilter = false;
        return this;
    }

    @Nonnull
    public SubFilterSelector skipModificationDateSubFilter() {
        this._selectModificationDateFilter = false;
        return this;
    }

    @Nonnull
    public SubFilterSelector skipEntityDynamicAttributeSubFilter(@Nonnull DynamicAttributeId id) {
        this._selectEntityDynAttFilter = Predicates.not((Predicate)Predicates.equalTo((Object)id));
        return this;
    }

    @Nonnull
    public SubFilterSelector skipArchiveSubFilter() {
        this._selectArchiveSubFilter = false;
        return this;
    }

    @Nonnull
    public SubFilterSelector skipBlockedSubFilter() {
        this._selectBlockedSubFilter = false;
        return this;
    }

    @Nonnull
    public SubFilterSelector skipChatUserSubFilter() {
        this._selectChatUserSubFilter = false;
        return this;
    }

    @Nonnull
    public SubFilterSelector skipEntityStatusSubFilter() {
        this._selectEntityStatusFilter = false;
        return this;
    }

    @Nonnull
    public SubFilterSelector skipTagSubFilter() {
        this._selectTagFilter = false;
        return this;
    }

    @Nonnull
    public SubFilterSelector skipConversationTypeSubFilter() {
        this._selectConversationTypeFilter = false;
        return this;
    }

    @Nonnull
    public SubFilterSelector selectDriveDocumentTypeSubFilter() {
        this._selectDriveDocumentTypeFilter = true;
        return this;
    }

    @Nonnull
    public ImmutableSet<SubFilter> on(@Nullable Set<SubFilter> subFilter) {
        if (subFilter == null) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (SubFilter sub : subFilter) {
            SelectionVisitor selectVisitor;
            SubFilter accepted = sub.accept(selectVisitor = new SelectionVisitor());
            if (accepted == null) continue;
            builder.add((Object)accepted);
        }
        return builder.build();
    }

    @CheckForNull
    public SubFilter first(@Nullable Set<SubFilter> subFilter, @Nullable SubFilter defaultValue) {
        return (SubFilter)Iterables.getFirst(this.on(subFilter), (Object)defaultValue);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("selectDateFilter", this._selectDateFilter).add("selectPersonRoleFilter", this._selectPersonRoleFilter).add("selectStartAndEndDateFilter", this._selectStartAndEndDateFilter).add("selectPersonIdFilter", this._selectPersonIdFilter).add("selectMemberFilter", this._selectMemberFilter).add("selectInheritMemberFilter", this._selectInheritMemberFilter).add("selectInheritAdminFilter", this._selectInheritAdminFilter).add("selectDocumentFileTypeFilter", this._selectDocumentFileTypeFilter).add("selectModificationDateFilter", this._selectModificationDateFilter).add("selectCoadminSubFilter", this._selectCoadminSubFilter).add("selectArchiveSubFilter", this._selectArchiveSubFilter).add("selectBlockedSubFilter", this._selectBlockedSubFilter).add("selectChatUserSubFilter", this._selectChatUserSubFilter).add("selectEntityStatusFilter", this._selectEntityStatusFilter).add("selectTagFilter", this._selectTagFilter).add("selectConversationTypeFilter", this._selectConversationTypeFilter).add("selectDriveDocumentTypeFilter", this._selectDriveDocumentTypeFilter).toString();
    }

    private class SelectionVisitor
    implements SubFilterVisitor<SubFilter> {
        private SelectionVisitor() {
        }

        @Override
        public SubFilter visitDateSubFilter(DateSubFilter filter) {
            return SubFilterSelector.this._selectDateFilter ? filter : null;
        }

        @Override
        public SubFilter visitStartAndEndDateSubFilter(StartAndEndDateSubFilter filter) {
            return SubFilterSelector.this._selectStartAndEndDateFilter ? filter : null;
        }

        @Override
        public SubFilter visitStartDateSubFilter(StartDateSubFilter filter) {
            return SubFilterSelector.this._selectStartDateFilter ? filter : null;
        }

        @Override
        public SubFilter visitPersonRoleSubFilter(PersonRoleSubFilter roleSubFilter) {
            return SubFilterSelector.this._selectPersonRoleFilter ? roleSubFilter : null;
        }

        @Override
        public SubFilter visitPersonIdSubFilter(PersonIdSubFilter personIdSubFilter) {
            return SubFilterSelector.this._selectPersonIdFilter ? personIdSubFilter : null;
        }

        @Override
        public SubFilter visitOrSubFilter(OrSubFilter orSubFilter) {
            ImmutableSet<SubFilter> filtered = SubFilterSelector.this.on((Set<SubFilter>)ImmutableSet.copyOf(orSubFilter.getChildFilter()));
            return filtered.isEmpty() ? null : new OrSubFilter((Set<SubFilter>)filtered);
        }

        @Override
        public SubFilter visitEntityMemberSubFilter(EntityMemberSubFilter entityMemberSubFilter) {
            return SubFilterSelector.this._selectMemberFilter ? entityMemberSubFilter : null;
        }

        @Override
        public SubFilter visitPublicationDate(PublicationDateFilter publicationDateFilter) {
            return publicationDateFilter;
        }

        @Override
        public SubFilter visitDocumentFileType(DocumentFileTypeSubFilter documentFileTypeSubfilter) {
            return SubFilterSelector.this._selectDocumentFileTypeFilter ? documentFileTypeSubfilter : null;
        }

        @Override
        public SubFilter visitModificationDate(ModificationDateSubFilter modificationDateSubFilter) {
            return SubFilterSelector.this._selectModificationDateFilter ? modificationDateSubFilter : null;
        }

        @Override
        public SubFilter visitEntityDynamicAttributeSubFilter(EntityDynamicAttributeSubFilter subFilter) {
            return SubFilterSelector.this._selectEntityDynAttFilter.apply((Object)subFilter.getAttributeId()) ? subFilter : null;
        }

        @Override
        public SubFilter visitInheritMemberSubFilter(InheritMemberSubFilter inheritMemberSubFilter) {
            return SubFilterSelector.this._selectInheritMemberFilter ? inheritMemberSubFilter : null;
        }

        @Override
        public SubFilter visitInheritAdminSubFilter(InheritAdminSubFilter inheritAdminSubFilter) {
            return SubFilterSelector.this._selectInheritAdminFilter ? inheritAdminSubFilter : null;
        }

        @Override
        public SubFilter visitCoadminSubFilter(CoadminSubFilter coadminSubFilter) {
            return SubFilterSelector.this._selectCoadminSubFilter ? coadminSubFilter : null;
        }

        @Override
        public SubFilter visitArchiveSubFilter(ArchiveSubFilter archiveSubFilter) {
            return SubFilterSelector.this._selectArchiveSubFilter ? archiveSubFilter : null;
        }

        @Override
        public SubFilter visitBlockedSubFilter(BlockSubFilter blockedSubFilter) {
            return SubFilterSelector.this._selectBlockedSubFilter ? blockedSubFilter : null;
        }

        @Override
        public SubFilter visitChatUserSubFilter(ChatUserSubFilter chatUserSubFilter) {
            return SubFilterSelector.this._selectChatUserSubFilter ? chatUserSubFilter : null;
        }

        @Override
        public SubFilter visitEntityStatusSubFilter(EntityStatusSubFilter entityStatusSubFilter) {
            return SubFilterSelector.this._selectEntityStatusFilter ? entityStatusSubFilter : null;
        }

        @Override
        public SubFilter visitTagSubFilter(TagSubFilter tagSubFilter) {
            return SubFilterSelector.this._selectTagFilter ? tagSubFilter : null;
        }

        @Override
        public SubFilter visitDriveFileTypeSubFilter(DriveFileTypeSubFilter driveFileTypeSubFilter) {
            return null;
        }

        @Override
        public SubFilter visitProfileAttributeSubFilter(ProfileAttributeSubFilter subfilter) {
            return SubFilterSelector.this._selectProfileAttributeFilter.apply((Object)subfilter.getName()) ? subfilter : null;
        }

        @Override
        public SubFilter visitDriveDocumentTypeSubFilter(DriveDocumentTypeSubFilter driveDocumentTypeSubfilter) {
            return SubFilterSelector.this._selectDriveDocumentTypeFilter ? driveDocumentTypeSubfilter : null;
        }
    }
}

