/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.shared.model;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.container.shared.model.EntityDurationTimeOption;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypes;
import de.justsoftware.onx.searchnew.shared.model.SearchConfigurationProvider;
import de.justsoftware.onx.searchnew.shared.model.SearchFacet;
import de.justsoftware.onx.searchnew.shared.model.StaticFilterType;
import de.justsoftware.onx.util.shared.NullIsFalsePredicate;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public enum StaticSearchFacet implements SearchFacet
{
    DATE_FUTURE{

        @Override
        public <R> R accept(SearchFacet.SearchFacetVisitor<R> visitor) {
            return visitor.visitDateFuture(this);
        }

        @Override
        public Predicate<FilterType> applyForFilterType(SearchConfigurationProvider searchConfigurationProvider) {
            return StaticSearchFacet.createEntityTypeDurationBasedPredicate(searchConfigurationProvider);
        }

        @Override
        public boolean applyWithoutFilterType(SearchConfigurationProvider searchConfigurationProvider) {
            return false;
        }
    }
    ,
    DATE_PAST{

        @Override
        public <R> R accept(SearchFacet.SearchFacetVisitor<R> visitor) {
            return visitor.visitDatePast(this);
        }

        @Override
        public Predicate<FilterType> applyForFilterType(SearchConfigurationProvider searchConfigurationProvider) {
            return StaticSearchFacet.createEntityTypeDurationBasedPredicate(searchConfigurationProvider);
        }

        @Override
        public boolean applyWithoutFilterType(SearchConfigurationProvider searchConfigurationProvider) {
            return false;
        }
    }
    ,
    DATE_ALL{

        @Override
        public <R> R accept(SearchFacet.SearchFacetVisitor<R> visitor) {
            return visitor.visitDateAll(this);
        }

        @Override
        public Predicate<FilterType> applyForFilterType(SearchConfigurationProvider searchConfigurationProvider) {
            return StaticSearchFacet.createEntityTypeDurationBasedPredicate(searchConfigurationProvider);
        }

        @Override
        public boolean applyWithoutFilterType(SearchConfigurationProvider searchConfigurationProvider) {
            return false;
        }
    }
    ,
    MODIFY_DATE_ALL{

        @Override
        public <R> R accept(SearchFacet.SearchFacetVisitor<R> visitor) {
            return visitor.visitModifyDateAll(this);
        }
    }
    ,
    MODIFY_DATE_LAST_HOUR{

        @Override
        public <R> R accept(SearchFacet.SearchFacetVisitor<R> visitor) {
            return visitor.visitModifyDateLastHour(this);
        }
    }
    ,
    MODIFY_DATE_LAST_24HOURS{

        @Override
        public <R> R accept(SearchFacet.SearchFacetVisitor<R> visitor) {
            return visitor.visitModifyDateLast24Hours(this);
        }
    }
    ,
    MODIFY_DATE_LAST_WEEK{

        @Override
        public <R> R accept(SearchFacet.SearchFacetVisitor<R> visitor) {
            return visitor.visitModifyDateLastWeek(this);
        }
    }
    ,
    MODIFY_DATE_LAST_MONTH{

        @Override
        public <R> R accept(SearchFacet.SearchFacetVisitor<R> visitor) {
            return visitor.visitModifyDateLastMonth(this);
        }
    }
    ,
    MODIFY_DATE_LAST_YEAR{

        @Override
        public <R> R accept(SearchFacet.SearchFacetVisitor<R> visitor) {
            return visitor.visitModifyDateLastYear(this);
        }
    }
    ,
    ARCHIVE_ALL{

        @Override
        public <R> R accept(SearchFacet.SearchFacetVisitor<R> visitor) {
            return visitor.visitArchiveAll(this);
        }
    }
    ,
    ARCHIVE_NON_ARCHIVED{

        @Override
        public <R> R accept(SearchFacet.SearchFacetVisitor<R> visitor) {
            return visitor.visitArchiveNonArchived(this);
        }
    }
    ,
    ARCHIVE_ARCHIVED{

        @Override
        public <R> R accept(SearchFacet.SearchFacetVisitor<R> visitor) {
            return visitor.visitArchiveArchived(this);
        }
    }
    ,
    BLOCK_ALL{

        @Override
        public <R> R accept(SearchFacet.SearchFacetVisitor<R> visitor) {
            return visitor.visitBlockAll(this);
        }

        @Override
        public Predicate<FilterType> applyForFilterType(SearchConfigurationProvider searchConfigurationProvider) {
            return Predicates.equalTo((Object)StaticFilterType.PROFILES);
        }
    }
    ,
    BLOCK_NON_BLOCKED{

        @Override
        public <R> R accept(SearchFacet.SearchFacetVisitor<R> visitor) {
            return visitor.visitBlockNonBlocked(this);
        }

        @Override
        public Predicate<FilterType> applyForFilterType(SearchConfigurationProvider searchConfigurationProvider) {
            return Predicates.equalTo((Object)StaticFilterType.PROFILES);
        }
    }
    ,
    BLOCK_BLOCKED{

        @Override
        public <R> R accept(SearchFacet.SearchFacetVisitor<R> visitor) {
            return visitor.visitBlockBlocked(this);
        }

        @Override
        public Predicate<FilterType> applyForFilterType(SearchConfigurationProvider searchConfigurationProvider) {
            return Predicates.equalTo((Object)StaticFilterType.PROFILES);
        }

        @Override
        public boolean applyWithoutFilterType(SearchConfigurationProvider searchConfigurationProvider) {
            return false;
        }
    }
    ,
    PERSON_ROLE{

        @Override
        public <R> R accept(SearchFacet.SearchFacetVisitor<R> visitor) {
            return visitor.visitPersonRole(this);
        }

        @Override
        public Predicate<FilterType> applyForFilterType(SearchConfigurationProvider searchConfigurationProvider) {
            return searchConfigurationProvider.isShowPersonRoleFilter() ? Predicates.equalTo((Object)StaticFilterType.PROFILES) : Predicates.alwaysFalse();
        }

        @Override
        public boolean applyWithoutFilterType(SearchConfigurationProvider searchConfigurationProvider) {
            return false;
        }
    }
    ,
    TAG{

        @Override
        public <R> R accept(SearchFacet.SearchFacetVisitor<R> visitor) {
            return visitor.visitTag(this);
        }

        @Override
        public Predicate<FilterType> applyForFilterType(SearchConfigurationProvider searchConfigurationProvider) {
            Predicate documentsPredicate = searchConfigurationProvider.isShowTagSearchFilterForDocuments() ? Predicates.in((Collection)ImmutableSet.of((Object)StaticFilterType.DOCUMENTS)) : Predicates.alwaysFalse();
            Predicate entityPredicate = Predicates.compose(StaticSearchFacet.createEntityTagFilterEnabledPredicate(searchConfigurationProvider), FilterTypes.TO_ENTITY_TYPE);
            return Predicates.or((Predicate)documentsPredicate, (Predicate)entityPredicate);
        }

        @Override
        public boolean applyWithoutFilterType(SearchConfigurationProvider searchConfigurationProvider) {
            return searchConfigurationProvider.isShowTagSearchFilterAnyFilterType();
        }
    }
    ,
    DRIVE_DOCUMENT_TYPE{

        @Override
        public <R> R accept(SearchFacet.SearchFacetVisitor<R> visitor) {
            return visitor.visitDriveDocumentType(this);
        }

        @Override
        public Predicate<FilterType> applyForFilterType(SearchConfigurationProvider searchConfigurationProvider) {
            return Predicates.equalTo((Object)StaticFilterType.DOCUMENTS);
        }

        @Override
        public boolean applyWithoutFilterType(SearchConfigurationProvider searchConfigurationProvider) {
            return false;
        }
    }
    ,
    DRIVE_FILE_TYPE{

        @Override
        public <R> R accept(SearchFacet.SearchFacetVisitor<R> visitor) {
            return visitor.visitDriveFileType(this);
        }

        @Override
        public Predicate<FilterType> applyForFilterType(SearchConfigurationProvider searchConfigurationProvider) {
            return Predicates.equalTo((Object)StaticFilterType.DOCUMENTS);
        }

        @Override
        public boolean applyWithoutFilterType(SearchConfigurationProvider searchConfigurationProvider) {
            return false;
        }
    };


    @Override
    public Predicate<FilterType> applyForFilterType(SearchConfigurationProvider searchConfigurationProvider) {
        return Predicates.alwaysTrue();
    }

    @Override
    public boolean applyWithoutFilterType(SearchConfigurationProvider searchConfigurationProvider) {
        return true;
    }

    @Override
    public String getFacetName() {
        return this.name();
    }

    @Nonnull
    private static Predicate<FilterType> createEntityTypeDurationBasedPredicate(final SearchConfigurationProvider searchConfigurationProvider) {
        return Predicates.compose((Predicate)new NullIsFalsePredicate<EntityType>(){

            @Override
            public boolean applySafe(EntityType input) {
                return searchConfigurationProvider.getDurationTimeOption(input) != EntityDurationTimeOption.OFF;
            }
        }, FilterTypes.TO_ENTITY_TYPE);
    }

    @Nonnull
    private static Predicate<EntityType> createEntityTagFilterEnabledPredicate(final SearchConfigurationProvider searchConfigurationProvider) {
        return new NullIsFalsePredicate<EntityType>(){

            @Override
            public boolean applySafe(EntityType input) {
                return searchConfigurationProvider.isShowTagSearchFilterForEntities(input);
            }
        };
    }
}

