/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.shared.model;

import de.justsoftware.onx.common.shared.model.Type;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.person.shared.model.PersonType;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypeVisitor;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public enum StaticFilterType implements FilterType
{
    ALL(Type.CommonTypes.ALL){

        @Override
        public <T> T accept(FilterTypeVisitor<T> v) {
            return v.visitAll();
        }
    }
    ,
    PROFILES(PersonType.PERSON){

        @Override
        public <T> T accept(FilterTypeVisitor<T> v) {
            return v.visitProfiles();
        }
    }
    ,
    NEWS_POSTS(ItemType.POST){

        @Override
        public <T> T accept(FilterTypeVisitor<T> v) {
            return v.visitNewsPosts();
        }
    }
    ,
    NEWS_CHANNELS(ItemType.CHANNEL){

        @Override
        public <T> T accept(FilterTypeVisitor<T> v) {
            return v.visitNewsChannels();
        }
    }
    ,
    WORKSTREAMS(StaticComponentType.WORKSTREAM){

        @Override
        public <T> T accept(FilterTypeVisitor<T> v) {
            return v.visitMicroblogs();
        }
    }
    ,
    CONVERSATIONS(ItemType.CONVERSATION){

        @Override
        public <T> T accept(FilterTypeVisitor<T> v) {
            return v.visitConversations();
        }
    }
    ,
    CHATS(ItemType.CHAT){

        @Override
        public <T> T accept(FilterTypeVisitor<T> v) {
            return v.visitChats();
        }
    }
    ,
    DOCUMENTS(ItemType.DRIVE_DOCUMENT){

        @Override
        public <T> T accept(FilterTypeVisitor<T> visitor) {
            return visitor.visitDocuments();
        }
    }
    ,
    WIKI_WIKIS(ItemType.WIKI_WIKI){

        @Override
        public <T> T accept(FilterTypeVisitor<T> visitor) {
            return visitor.visitWiki();
        }
    }
    ,
    WIKI_CHAPTERS(ItemType.WIKI_CHAPTER){

        @Override
        public <T> T accept(FilterTypeVisitor<T> visitor) {
            return visitor.visitChapter();
        }
    }
    ,
    WIKI_ARTICLES(ItemType.WIKI_ARTICLE){

        @Override
        public <T> T accept(FilterTypeVisitor<T> visitor) {
            return visitor.visitArticle();
        }
    };

    private final Type _type;

    private StaticFilterType(Type type) {
        this._type = type;
    }

    @Override
    public Type getType() {
        return this._type;
    }

    @Override
    public String getName() {
        return this.name();
    }
}

