/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.shared.model;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import de.justsoftware.onx.common.shared.model.EnumWithLongId;
import de.justsoftware.onx.common.shared.util.Enums2;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public enum SortType implements EnumWithLongId
{
    RELEVANCE(1L, "score desc", new Acceptor(){

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitRelevance();
        }
    }),
    ACTIVITY(2L, "modify_date desc", new Acceptor(){

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitActivity();
        }
    }),
    ALPHABETICAL(3L, "name_sort asc", new Acceptor(){

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitAlphabetical();
        }
    }),
    TIME_ASCENDING(4L, "start_date asc", new Acceptor(){

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitTimeAscending();
        }
    }),
    TIME_DESCENDING(5L, "start_date desc", new Acceptor(){

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitTimeDescending();
        }
    }),
    PUBLICATION_DATE(6L, "publication_date desc", new Acceptor(){

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitPublicationDate();
        }
    }),
    EXPIRATION_DATE(7L, "expiration_date asc", new Acceptor(){

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitExpirationDate();
        }
    });

    public static final ImmutableMap<String, SortType> VALUE_OF_MAP;
    private static final ImmutableMap<Long, SortType> BY_ID_MAP;
    private final long _id;
    private final String _sortCriteria;
    private final Acceptor _acceptor;

    private SortType(long id, String sortCriteria, Acceptor acceptor) {
        this._id = id;
        this._sortCriteria = sortCriteria;
        this._acceptor = acceptor;
    }

    @Override
    public long getId() {
        return this._id;
    }

    @CheckForNull
    public static SortType getById(@Nullable Long id) {
        return (SortType)BY_ID_MAP.get((Object)id);
    }

    @Nonnull
    public String getSortCriteria() {
        return this._sortCriteria;
    }

    @Nonnull
    public <T> T accept(Visitor<T> visitor) {
        return this._acceptor.accept(visitor);
    }

    static {
        VALUE_OF_MAP = Enums2.index((Enum[])SortType.values());
        BY_ID_MAP = Maps.uniqueIndex((Iterator)Iterators.forArray((Object[])SortType.values()), (Function)TO_ID);
    }

    public static interface Visitor<T> {
        @Nonnull
        public T visitActivity();

        @Nonnull
        public T visitAlphabetical();

        @Nonnull
        public T visitRelevance();

        @Nonnull
        public T visitTimeAscending();

        @Nonnull
        public T visitTimeDescending();

        @Nonnull
        public T visitPublicationDate();

        @Nonnull
        public T visitExpirationDate();
    }

    private static interface Acceptor {
        @Nonnull
        public <T> T accept(@Nonnull Visitor<T> var1);
    }
}

