/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.shared.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.searchnew.shared.model.SearchFacet;
import de.justsoftware.onx.searchnew.shared.model.SearchFacetCounts;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SimpleSearchFacetCounts
implements SearchFacetCounts {
    private static final long serialVersionUID = 1L;
    private ImmutableMap<String, Long> _facetCounts;
    private ImmutableMap<String, String> _highlightedFacetValues;
    private SearchFacetCounts.FacetSortType _sortType;

    @Deprecated
    SimpleSearchFacetCounts() {
    }

    public SimpleSearchFacetCounts(@Nonnull ImmutableMap<String, Long> facetCounts, @Nonnull ImmutableMap<String, String> highlightedFacetValues, @Nonnull SearchFacetCounts.FacetSortType sortType) {
        this._facetCounts = facetCounts;
        this._highlightedFacetValues = highlightedFacetValues;
        this._sortType = sortType;
    }

    @CheckForNull
    public static SearchFacetCounts ofSingleCount(@Nonnull SearchFacet facet, @Nullable Integer count, @Nonnull SearchFacetCounts.FacetSortType sortType) {
        if (count == null) {
            return null;
        }
        return new SimpleSearchFacetCounts((ImmutableMap<String, Long>)ImmutableMap.of((Object)facet.getFacetName(), (Object)count.longValue()), (ImmutableMap<String, String>)ImmutableMap.of(), sortType);
    }

    @Override
    public SearchFacetCounts.FacetSortType getSortType() {
        return this._sortType;
    }

    @CheckForNull
    public Long getFacetCount(@Nonnull String key) {
        return (Long)this._facetCounts.get((Object)key);
    }

    @Nonnull
    public ImmutableMap<String, Long> getFacetCounts() {
        return this._facetCounts;
    }

    @Nonnull
    public ImmutableMap<String, String> getHighlightedFacetValues() {
        return this._highlightedFacetValues;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sortType", (Object)this._sortType).add("facetCounts", this._facetCounts).add("highlightedFacetValues", this._highlightedFacetValues).toString();
    }

    @Override
    public <T> T accept(SearchFacetCounts.SearchFacetCountsVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

