/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.shared.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypeCountType;
import de.justsoftware.onx.searchnew.shared.model.SearchFacet;
import de.justsoftware.onx.searchnew.shared.model.SearchFacetCounts;
import de.justsoftware.onx.searchnew.shared.model.SearchProvider;
import de.justsoftware.onx.searchnew.shared.model.SearchProviderId;
import de.justsoftware.onx.searchnew.shared.model.SearchResultEntry;
import java.io.Serializable;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class SearchResult<T extends SearchResultEntry>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int _numberOfResults;
    private ImmutableList<T> _results;
    private ImmutableMap<FilterType, ImmutableMultiset<FilterTypeCountType>> _filterCount;
    private ImmutableMap<SearchFacet, SearchFacetCounts> _facetCounts;
    private SearchProvider _searchProvider;
    private boolean _moreResults = false;

    @Deprecated
    public SearchResult() {
    }

    public SearchResult(int numberOfResults, @Nonnull ImmutableList<T> results) {
        this(numberOfResults, results, (ImmutableMap<FilterType, ImmutableMultiset<FilterTypeCountType>>)ImmutableMap.of(), (ImmutableMap<SearchFacet, SearchFacetCounts>)ImmutableMap.of(), SearchProvider.JUCO_PROVIDER);
    }

    public SearchResult(int numberOfResults, @Nonnull ImmutableList<T> results, @Nonnull SearchProvider searchProvider) {
        this(numberOfResults, results, (ImmutableMap<FilterType, ImmutableMultiset<FilterTypeCountType>>)ImmutableMap.of(), (ImmutableMap<SearchFacet, SearchFacetCounts>)ImmutableMap.of(), searchProvider);
    }

    public SearchResult(int numberOfResults, @Nonnull ImmutableList<T> results, @Nonnull ImmutableMap<FilterType, ImmutableMultiset<FilterTypeCountType>> filterCount, @Nonnull ImmutableMap<SearchFacet, SearchFacetCounts> facetCounts) {
        this(numberOfResults, results, filterCount, facetCounts, SearchProvider.JUCO_PROVIDER);
    }

    public SearchResult(int numberOfResults, @Nonnull ImmutableList<T> results, @Nonnull ImmutableMap<FilterType, ImmutableMultiset<FilterTypeCountType>> filterCount, @Nonnull ImmutableMap<SearchFacet, SearchFacetCounts> facetCounts, @Nonnull SearchProvider searchProvider) {
        this._numberOfResults = numberOfResults;
        this._results = results;
        this._filterCount = filterCount;
        this._facetCounts = facetCounts;
        this._searchProvider = searchProvider;
    }

    public int getNumberOfResults() {
        return this._numberOfResults;
    }

    @Nonnull
    public ImmutableList<T> getResults() {
        return this._results;
    }

    @Nonnull
    public ImmutableMap<FilterType, ImmutableMultiset<FilterTypeCountType>> getFilterCount() {
        return this._filterCount;
    }

    @Nonnull
    public static <T extends SearchResultEntry> SearchResult<T> empty() {
        return new SearchResult<T>(0, ImmutableList.of());
    }

    @Nonnull
    public ImmutableMap<SearchFacet, SearchFacetCounts> getFacetCounts() {
        return this._facetCounts;
    }

    @CheckForNull
    public SearchFacetCounts getFacetCount(@Nonnull SearchFacet facet) {
        return (SearchFacetCounts)this._facetCounts.get((Object)facet);
    }

    @Nonnull
    public SearchProviderId getSearchProviderId() {
        return this._searchProvider.getId();
    }

    @Nonnull
    public SearchProvider getSearchProvider() {
        return this._searchProvider;
    }

    public void setHasMoreResults(boolean moreResults) {
        this._moreResults = moreResults;
    }

    public boolean hasMoreResults() {
        return this._moreResults;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("numberOfResults", this._numberOfResults).toString();
    }
}

