/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.shared.model;

import com.freiheit.toro.common.shared.util.ClientStringUtil;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.Type;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeId;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.common.shared.util.HistoryToken;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.shared.model.ChildEntityTeaserSortType;
import de.justsoftware.onx.container.shared.model.EntityDurationTimeOption;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.searchnew.shared.model.ArchiveSubFilter;
import de.justsoftware.onx.searchnew.shared.model.BlockSubFilter;
import de.justsoftware.onx.searchnew.shared.model.DateSubFilter;
import de.justsoftware.onx.searchnew.shared.model.DocumentFileTypeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.EntityDynamicAttributeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.EntityFilterType;
import de.justsoftware.onx.searchnew.shared.model.EntityFilterTypeSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.EntityStatusSubFilter;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypeCountType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypeSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.FilterTypes;
import de.justsoftware.onx.searchnew.shared.model.ModificationDateSubFilter;
import de.justsoftware.onx.searchnew.shared.model.PersonRoleSubFilter;
import de.justsoftware.onx.searchnew.shared.model.ProfileAttributeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.SearchConfigurationProvider;
import de.justsoftware.onx.searchnew.shared.model.SearchContext;
import de.justsoftware.onx.searchnew.shared.model.SearchContextModel;
import de.justsoftware.onx.searchnew.shared.model.SearchFacetParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchProvider;
import de.justsoftware.onx.searchnew.shared.model.SearchProviderId;
import de.justsoftware.onx.searchnew.shared.model.SortType;
import de.justsoftware.onx.searchnew.shared.model.StaticFilterType;
import de.justsoftware.onx.searchnew.shared.model.SubFilter;
import de.justsoftware.onx.searchnew.shared.model.SubFilterSelector;
import de.justsoftware.onx.searchnew.shared.model.SubfilterForFilterTypeVisitor;
import de.justsoftware.onx.searchnew.shared.model.TagSubFilter;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class SearchParameters
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String _searchString;
    private FilterType _filter;
    private SearchContext _context;
    private GlobalId _contextId;
    private ImmutableList<EntityId> _contextHierarchy;
    private SortType _sortType;
    private ImmutableSet<SubFilter> _subfilter;
    private SearchProviderId _searchProviderId;
    private HistoryToken _token;
    private SearchFacetParameters _searchFacets;
    private boolean _isNavigatorSearch;
    private EntityType _navigatorRootEntityType;

    @Deprecated
    public SearchParameters() {
    }

    public SearchParameters(@Nullable String searchString, @Nullable FilterType filter, @Nullable SearchContext context, @Nullable GlobalId contextId, @Nullable List<EntityId> contextHierarchy, @Nullable SortType sortType, @Nullable Set<? extends SubFilter> subfilter, @Nullable SearchProviderId searchProvider, SearchFacetParameters searchFacets) {
        this(searchString, filter, context, contextId, contextHierarchy, sortType, subfilter, searchProvider, searchFacets, false, null);
    }

    public SearchParameters(@Nullable String searchString, @Nullable FilterType filter, @Nullable SearchContext context, @Nullable GlobalId contextId, @Nullable List<EntityId> contextHierarchy, @Nullable SortType sortType, @Nullable Set<? extends SubFilter> subfilter, @Nullable SearchProviderId searchProvider, SearchFacetParameters searchFacets, boolean isNavigatorSearch, @Nullable EntityType navigatorRootEntityType) {
        this(searchString, filter, context, contextId, contextHierarchy, sortType, subfilter, searchProvider, searchFacets, HistoryToken.SEARCH_TEXT, isNavigatorSearch, navigatorRootEntityType);
    }

    public SearchParameters(@Nullable String searchString, @Nullable FilterType filter, @Nullable SearchContext context, @Nullable GlobalId contextId, @Nullable List<EntityId> contextHierarchy, @Nullable SortType sortType, @Nullable Set<? extends SubFilter> subfilter, @Nullable SearchProviderId searchProvider, SearchFacetParameters searchFacets, @Nullable HistoryToken historyToken) {
        this(searchString, filter, context, contextId, contextHierarchy, sortType, subfilter, searchProvider, searchFacets, historyToken, false, null);
    }

    public SearchParameters(@Nullable String searchString, @Nullable FilterType filter, @Nullable SearchContext context, @Nullable GlobalId contextId, @Nullable List<EntityId> contextHierarchy, @Nullable SortType sortType, @Nullable Set<? extends SubFilter> subfilter, @Nullable SearchProviderId searchProvider, SearchFacetParameters searchFacets, @Nullable HistoryToken historyToken, boolean isNavigatorSearch, @Nullable EntityType navigatorRootEntityType) {
        this._token = historyToken;
        this._searchString = searchString;
        this._filter = filter;
        this._context = context;
        this._contextId = contextId;
        this._contextHierarchy = contextHierarchy != null ? ImmutableList.copyOf(contextHierarchy) : ImmutableList.of();
        this._sortType = sortType;
        this._subfilter = subfilter != null ? ImmutableSet.copyOf(subfilter) : ImmutableSet.of();
        this._searchProviderId = searchProvider != null ? searchProvider : SearchProviderId.JUCO_ID;
        this._searchFacets = searchFacets;
        this._isNavigatorSearch = isNavigatorSearch;
        this._navigatorRootEntityType = navigatorRootEntityType;
    }

    @CheckForNull
    public String getText() {
        return this._searchString;
    }

    public boolean hasText() {
        return ClientStringUtil.hasText(this._searchString);
    }

    @Nonnull
    public ImmutableSet<SubFilter> getSubfilter() {
        return this._subfilter;
    }

    public boolean hasFilterOrSubFilter() {
        return this.hasFilter() || this.hasSubFilter();
    }

    public boolean hasFilter() {
        return this._filter != null && StaticFilterType.ALL != this._filter;
    }

    public boolean hasNonnullFilter() {
        return this._filter != null;
    }

    private boolean hasSubFilter() {
        return !CollectionUtil.isEmpty(this._subfilter);
    }

    @Nonnull
    public HistoryToken getToken() {
        return this._token;
    }

    public boolean hasDefaultSearchProvider() {
        return this._searchProviderId == null || this._searchProviderId.equals(SearchProviderId.JUCO_ID);
    }

    @CheckForNull
    public DateSubFilter getDateSubfilter() {
        return (DateSubFilter)SubFilterSelector.skipAll().selectDateSubFilter().first((Set<SubFilter>)this._subfilter, null);
    }

    @CheckForNull
    public DocumentFileTypeSubFilter getDocumentFileTypeSubFilter() {
        return (DocumentFileTypeSubFilter)SubFilterSelector.skipAll().selectDocumentFileTypeSubFilter().first((Set<SubFilter>)this._subfilter, null);
    }

    @CheckForNull
    public PersonRoleSubFilter getPersonRoleSubfilter() {
        return (PersonRoleSubFilter)SubFilterSelector.skipAll().selectPersonRoleSubFilter().first((Set<SubFilter>)this._subfilter, null);
    }

    @CheckForNull
    public ModificationDateSubFilter getModificationDateSubfilter() {
        return (ModificationDateSubFilter)SubFilterSelector.skipAll().selectModificationDateSubFilter().first((Set<SubFilter>)this._subfilter, null);
    }

    @CheckForNull
    public EntityDynamicAttributeSubFilter getEntityDynamicAttributeSubFilter(DynamicAttributeId id) {
        return (EntityDynamicAttributeSubFilter)SubFilterSelector.skipAll().selectEntityDynamicAttributeSubFilter(id).first((Set<SubFilter>)this._subfilter, null);
    }

    @CheckForNull
    public ProfileAttributeSubFilter getProfileAttributeSubFilter(String name) {
        return (ProfileAttributeSubFilter)SubFilterSelector.skipAll().selectProfileAttributeSubFilter(name).first((Set<SubFilter>)this._subfilter, null);
    }

    @CheckForNull
    public ArchiveSubFilter getArchiveSubfilter() {
        return (ArchiveSubFilter)SubFilterSelector.skipAll().selectArchiveSubFilter().first((Set<SubFilter>)this._subfilter, null);
    }

    @CheckForNull
    public BlockSubFilter getBlockedSubfilter() {
        return (BlockSubFilter)SubFilterSelector.skipAll().selectBlockedSubFilter().first((Set<SubFilter>)this._subfilter, null);
    }

    @CheckForNull
    public EntityStatusSubFilter getEntityStatusSubfilter() {
        return (EntityStatusSubFilter)SubFilterSelector.skipAll().selectEntityStatusSubFilter().first((Set<SubFilter>)this._subfilter, null);
    }

    @CheckForNull
    public TagSubFilter getTagSubfilter() {
        return (TagSubFilter)SubFilterSelector.skipAll().selectTagSubFilter().first((Set<SubFilter>)this._subfilter, null);
    }

    @CheckForNull
    public FilterType getFilterType() {
        return this._filter;
    }

    @Nonnull
    public FilterType getFilterTypeOrAll() {
        return this._filter != null ? this._filter : StaticFilterType.ALL;
    }

    @CheckForNull
    public Type getFilterTypeType() {
        FilterType ft = this._filter;
        return ft != null ? ft.getType() : null;
    }

    @CheckForNull
    public SearchContext getSearchContext() {
        return this._context;
    }

    @Nonnull
    public SearchContext getSearchContextOrEntirePlatform() {
        return this._context != null ? this._context : SearchContext.ENTIRE_PLATFORM;
    }

    @CheckForNull
    public SortType getSortType() {
        return this._sortType;
    }

    @CheckForNull
    public GlobalId getContextId() {
        return this._contextId;
    }

    @CheckForNull
    public EntityId getContextEntityId() {
        return this._contextId != null && this._contextId.getType() == ItemType.ENTITY ? (EntityId)this._contextId : null;
    }

    @CheckForNull
    public ProfileId getContextProfileId() {
        return this._contextId != null && this._contextId.getType() == ItemType.PROFILE ? (ProfileId)this._contextId : null;
    }

    @CheckReturnValue
    public boolean hasSameContextIdAs(@Nullable SearchParameters other) {
        return other == null ? this._contextId == null : Objects.equal((Object)this._contextId, (Object)other.getContextId());
    }

    @Nonnull
    public ImmutableList<EntityId> getContextHierarchy() {
        return this._contextHierarchy;
    }

    @Nonnull
    @CheckReturnValue
    public SearchParameters withText(@Nullable String text) {
        return new SearchParameters(text, this._filter, this._context, this._contextId, (List<EntityId>)this._contextHierarchy, this._sortType, (Set<? extends SubFilter>)this._subfilter, this._searchProviderId, this._searchFacets, this._token, this._isNavigatorSearch, this._navigatorRootEntityType);
    }

    @Nonnull
    @CheckReturnValue
    public SearchParameters withSearchProvider(@Nullable SearchProviderId searchProviderId) {
        return new SearchParameters(this._searchString, this._filter, this._context, this._contextId, (List<EntityId>)this._contextHierarchy, this._sortType, (Set<? extends SubFilter>)this._subfilter, searchProviderId, this._searchFacets, this._token, this._isNavigatorSearch, this._navigatorRootEntityType);
    }

    @Nonnull
    @CheckReturnValue
    public SearchParameters withSearchProvider(@Nullable SearchProvider searchProvider) {
        return this.withSearchProvider(searchProvider != null ? searchProvider.getId() : null);
    }

    @Nonnull
    @CheckReturnValue
    public SearchParameters withFilter(@Nullable FilterType filter) {
        return new SearchParameters(this._searchString, filter, this._context, this._contextId, (List<EntityId>)this._contextHierarchy, this._sortType, (Set<? extends SubFilter>)this._subfilter, this._searchProviderId, this._searchFacets, this._token, this._isNavigatorSearch, this._navigatorRootEntityType);
    }

    public boolean hasFilter(@Nullable FilterType filter) {
        return Objects.equal((Object)this._filter, (Object)filter);
    }

    public boolean hasSameFilterAs(@Nullable SearchParameters other) {
        return this.hasFilter(other != null ? other.getFilterType() : null);
    }

    @Nonnull
    @CheckReturnValue
    public SearchContextModel synthesizeContextModel() {
        return SearchContextModel.create(this._context, this._contextId);
    }

    @Nonnull
    @CheckReturnValue
    public SearchParameters withSearchContext(@Nullable SearchContext context) {
        return new SearchParameters(this._searchString, this._filter, context, this._contextId, (List<EntityId>)this._contextHierarchy, this._sortType, (Set<? extends SubFilter>)this._subfilter, this._searchProviderId, this._searchFacets, this._token, this._isNavigatorSearch, this._navigatorRootEntityType);
    }

    @Nonnull
    @CheckReturnValue
    public SearchParameters withEntityId(@Nullable EntityId entityId) {
        return new SearchParameters(this._searchString, this._filter, this._context, entityId, (List<EntityId>)this._contextHierarchy, this._sortType, (Set<? extends SubFilter>)this._subfilter, this._searchProviderId, this._searchFacets, this._token, this._isNavigatorSearch, this._navigatorRootEntityType);
    }

    @Nonnull
    @CheckReturnValue
    public SearchParameters withContextHierarchy(@Nullable List<EntityId> contextHierarchy) {
        ImmutableList newContextHierarchy = contextHierarchy != null ? ImmutableList.copyOf(contextHierarchy) : ImmutableList.of();
        return new SearchParameters(this._searchString, this._filter, this._context, this._contextId, (List<EntityId>)newContextHierarchy, this._sortType, (Set<? extends SubFilter>)this._subfilter, this._searchProviderId, this._searchFacets, this._token, this._isNavigatorSearch, this._navigatorRootEntityType);
    }

    @Nonnull
    @CheckReturnValue
    public SearchParameters withSortType(@Nullable SortType sortType) {
        return new SearchParameters(this._searchString, this._filter, this._context, this._contextId, (List<EntityId>)this._contextHierarchy, sortType, (Set<? extends SubFilter>)this._subfilter, this._searchProviderId, this._searchFacets, this._token, this._isNavigatorSearch, this._navigatorRootEntityType);
    }

    @Nonnull
    @CheckReturnValue
    public SearchParameters withoutSortType() {
        return this.withSortType(null);
    }

    @Nonnull
    @CheckReturnValue
    public SearchParameters withSubfilters(@Nullable Set<? extends SubFilter> subfilter) {
        return new SearchParameters(this._searchString, this._filter, this._context, this._contextId, (List<EntityId>)this._contextHierarchy, this._sortType, subfilter, this._searchProviderId, this._searchFacets, this._token, this._isNavigatorSearch, this._navigatorRootEntityType);
    }

    @Nonnull
    @CheckReturnValue
    public SearchParameters withAdditionalSubfilter(SubFilter subfilter) {
        ImmutableSet allSubfilters = FluentIterable.from(this._subfilter).append((Object[])new SubFilter[]{subfilter}).toSet();
        return new SearchParameters(this._searchString, this._filter, this._context, this._contextId, (List<EntityId>)this._contextHierarchy, this._sortType, (Set<? extends SubFilter>)allSubfilters, this._searchProviderId, this._searchFacets, this._token, this._isNavigatorSearch, this._navigatorRootEntityType);
    }

    @Nonnull
    @CheckReturnValue
    public SearchParameters withAdditionalSubfilters(Set<? extends SubFilter> subfilter) {
        ImmutableSet allSubfilters = FluentIterable.from(this._subfilter).append(subfilter).toSet();
        return new SearchParameters(this._searchString, this._filter, this._context, this._contextId, (List<EntityId>)this._contextHierarchy, this._sortType, (Set<? extends SubFilter>)allSubfilters, this._searchProviderId, this._searchFacets, this._token, this._isNavigatorSearch, this._navigatorRootEntityType);
    }

    @Nonnull
    @CheckReturnValue
    public SearchParameters withoutSubfilters() {
        return new SearchParameters(this._searchString, this._filter, this._context, this._contextId, (List<EntityId>)this._contextHierarchy, this._sortType, null, this._searchProviderId, this._searchFacets, this._token, this._isNavigatorSearch, this._navigatorRootEntityType);
    }

    @Nonnull
    @CheckReturnValue
    public SearchParameters withFallbacks(SearchConfigurationProvider config, SearchParameters defaultParameters) {
        FilterType filter = this._filter != null ? this._filter : defaultParameters.getFilterType();
        SearchContext searchContext = this._context != null ? this._context : defaultParameters.getSearchContext();
        SortType sortType = this._sortType != null ? this._sortType : SearchParameters.createDefaultSortType(config, this._searchString, this._filter, this.getDateSubfilter());
        ImmutableSet<SubFilter> subfilter = this._subfilter != null ? this._subfilter : SearchParameters.createDefaultSubFilter(config, sortType, filter);
        return new SearchParameters(this._searchString, filter, searchContext, this._contextId, (List<EntityId>)this._contextHierarchy, sortType, (Set<? extends SubFilter>)subfilter, this._searchProviderId, this._searchFacets, this._token, this._isNavigatorSearch, this._navigatorRootEntityType);
    }

    @Nonnull
    @CheckReturnValue
    public SearchParameters withDefaultSortTypeAndSubfilter(SearchConfigurationProvider config) {
        SortType sortType = SearchParameters.createDefaultSortType(config, this._searchString, this._filter, this.getDateSubfilter());
        return new SearchParameters(this._searchString, this._filter, this._context, this._contextId, (List<EntityId>)this._contextHierarchy, sortType, (Set<? extends SubFilter>)SearchParameters.createDefaultSubFilter(config, sortType, this._filter), this._searchProviderId, this._searchFacets, this._token, this._isNavigatorSearch, this._navigatorRootEntityType);
    }

    @Nonnull
    @CheckReturnValue
    public SearchParameters withDefaultSubfilter(SearchConfigurationProvider config) {
        return new SearchParameters(this._searchString, this._filter, this._context, this._contextId, (List<EntityId>)this._contextHierarchy, this._sortType, (Set<? extends SubFilter>)SearchParameters.createDefaultSubFilter(config, this._sortType, this._filter), this._searchProviderId, this._searchFacets, this._token, this._isNavigatorSearch, this._navigatorRootEntityType);
    }

    public SearchParameters withDefaultSearchContext() {
        return new SearchParameters(this._searchString, this._filter, this.getSearchContextOrEntirePlatform().isMyContentContext() ? SearchContext.MY_CONTENT : SearchContext.ENTIRE_PLATFORM, this._contextId, (List<EntityId>)this._contextHierarchy, this._sortType, (Set<? extends SubFilter>)this._subfilter, this._searchProviderId, this._searchFacets, this._token, this._isNavigatorSearch, this._navigatorRootEntityType);
    }

    @Nonnull
    @CheckReturnValue
    public SearchParameters withHistoryToken(HistoryToken token) {
        return new SearchParameters(this._searchString, this._filter, this._context, this._contextId, (List<EntityId>)this._contextHierarchy, this._sortType, (Set<? extends SubFilter>)this._subfilter, this._searchProviderId, this._searchFacets, token, this._isNavigatorSearch, this._navigatorRootEntityType);
    }

    @Nonnull
    @CheckReturnValue
    public SearchParameters withSearchFacetParameters(SearchFacetParameters searchFacets) {
        return new SearchParameters(this._searchString, this._filter, this._context, this._contextId, (List<EntityId>)this._contextHierarchy, this._sortType, (Set<? extends SubFilter>)this._subfilter, this._searchProviderId, searchFacets, this._token, this._isNavigatorSearch, this._navigatorRootEntityType);
    }

    public boolean isEqualTo(SearchParameters other) {
        return Objects.equal((Object)this._searchString, (Object)other._searchString) && Objects.equal((Object)this._filter, (Object)other._filter) && this._sortType == other._sortType && Objects.equal((Object)this._contextId, (Object)other._contextId) && Objects.equal(this._contextHierarchy, other._contextHierarchy) && this._context == other._context && Objects.equal(this._subfilter, other._subfilter) && Objects.equal((Object)this._searchProviderId, (Object)other._searchProviderId) && this._searchFacets.equals(other._searchFacets) && this._isNavigatorSearch == other._isNavigatorSearch && Objects.equal((Object)this._navigatorRootEntityType, (Object)other._navigatorRootEntityType);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("searchString", (Object)this._searchString).add("filter", (Object)this._filter).add("context", (Object)this._context).add("contextId", (Object)this._contextId).add("contextHierarchy", this._contextHierarchy).add("sortType", (Object)this._sortType).add("subfilter", this._subfilter).add("searchProvider", (Object)this._searchProviderId).add("searchFacets", (Object)this._searchFacets).add("isNavigatorSearch", this._isNavigatorSearch).add("navigatorRootEntityType", (Object)this._navigatorRootEntityType).toString();
    }

    @Nonnull
    public static SortType createDefaultSortType(SearchConfigurationProvider config, @Nullable String searchString, FilterTypeSearchFacet searchFacet, @Nullable DateSubFilter dateSubfilter) {
        return searchFacet instanceof EntityFilterTypeSearchFacet ? SearchParameters.createDefaultSortType(config, searchString, ((EntityFilterTypeSearchFacet)searchFacet).getCountType(), searchFacet.getFilterType(), dateSubfilter) : SearchParameters.createDefaultSortType(config, searchString, searchFacet.getFilterType(), dateSubfilter);
    }

    @Nonnull
    private static SortType createDefaultSortType(SearchConfigurationProvider config, @Nullable String searchString, FilterTypeCountType countType, @Nullable FilterType filterType, @Nullable DateSubFilter dateSubfilter) {
        switch (countType) {
            case FUTURE: {
                return SortType.TIME_ASCENDING;
            }
            case PAST: {
                return SortType.TIME_DESCENDING;
            }
            case STANDARD: {
                return SearchParameters.createDefaultSortType(config, searchString, filterType, dateSubfilter);
            }
        }
        return SearchParameters.createDefaultSortType(config, searchString, filterType, dateSubfilter);
    }

    @Nonnull
    public static SortType createDefaultSortType(SearchConfigurationProvider config, @Nullable String searchString, @Nullable FilterType filterType, @Nullable DateSubFilter dateSubfilter) {
        if (StringUtil.isBlank(searchString)) {
            if (SearchParameters.hasDurationTimeActivated(config, filterType)) {
                if (dateSubfilter == null || dateSubfilter.equals(DateSubFilter.FUTURE)) {
                    return SortType.TIME_ASCENDING;
                }
                return SortType.TIME_DESCENDING;
            }
            return SortType.ALPHABETICAL;
        }
        return SortType.RELEVANCE;
    }

    private static boolean hasDurationTimeActivated(SearchConfigurationProvider config, @Nullable FilterType filterType) {
        if (filterType instanceof EntityFilterType) {
            EntityType entityType = ((EntityFilterType)filterType).getType();
            return config.getDurationTimeOption(entityType) != EntityDurationTimeOption.OFF;
        }
        return false;
    }

    @Nonnull
    public static ImmutableSet<SubFilter> createDefaultSubFilter(SearchConfigurationProvider config, @Nullable SortType sortType, @Nullable FilterType filter) {
        ImmutableSet.Builder defaultSubfilter = ImmutableSet.builder();
        if (sortType == SortType.TIME_ASCENDING) {
            defaultSubfilter.add((Object)DateSubFilter.FUTURE);
        } else if (sortType == SortType.TIME_DESCENDING) {
            defaultSubfilter.add((Object)DateSubFilter.PAST);
        }
        if (filter != null) {
            defaultSubfilter.addAll((Iterable)filter.accept(new SubfilterForFilterTypeVisitor(config)));
        }
        return defaultSubfilter.build();
    }

    public boolean isSortTypeSupported(SearchConfigurationProvider config, @Nullable SortType sortType) {
        return SearchParameters.isSortTypeSupported(config, this._filter, sortType);
    }

    public static boolean isSortTypeSupported(SearchConfigurationProvider config, @Nullable FilterType selectedFilter, @Nullable SortType sortType) {
        if (sortType == null) {
            return true;
        }
        switch (sortType) {
            case TIME_ASCENDING: 
            case TIME_DESCENDING: {
                return SearchParameters.hasDurationTimeActivated(config, selectedFilter);
            }
            case ACTIVITY: 
            case ALPHABETICAL: 
            case RELEVANCE: 
            case PUBLICATION_DATE: {
                return true;
            }
            case EXPIRATION_DATE: {
                return config.isSortableByExpirationDate((EntityType)FilterTypes.TO_ENTITY_TYPE.apply((Object)selectedFilter));
            }
        }
        return true;
    }

    public boolean hasDurationTimeActivatedFilter(SearchConfigurationProvider config) {
        return SearchParameters.hasDurationTimeActivated(config, this.getFilterType());
    }

    @CheckReturnValue
    @Nonnull
    public SearchParameters withChildEntityTeaserSortType(ChildEntityTeaserSortType childEntityTeaserSortOrder) {
        switch (childEntityTeaserSortOrder) {
            case SORT_BY_ACTIVITY: {
                return this.withSortType(SortType.ACTIVITY);
            }
            case SORT_BY_PUBLICATION_DATE: {
                return this.withSortType(SortType.PUBLICATION_DATE);
            }
        }
        return this.withSortType(null);
    }

    @Nonnull
    public SearchProviderId getSearchProvider() {
        return this._searchProviderId;
    }

    @Nonnull
    public SearchContextModel getSearchContextModel() {
        return SearchContextModel.create(this._context, this._contextId);
    }

    public boolean hasSameQueryAs(SearchParameters searchParameters) {
        return Objects.equal((Object)this.getText(), (Object)searchParameters.getText());
    }

    @Nonnull
    public SearchFacetParameters getSearchFacets() {
        return this._searchFacets;
    }

    public boolean isNavigatorSearch() {
        return this._isNavigatorSearch;
    }

    @Nonnull
    @CheckReturnValue
    public SearchParameters isNavigatorSearch(boolean isNavigatorSearch) {
        return new SearchParameters(this._searchString, this._filter, this._context, this._contextId, (List<EntityId>)this._contextHierarchy, this._sortType, (Set<? extends SubFilter>)this._subfilter, this._searchProviderId, this._searchFacets, this._token, isNavigatorSearch, this._navigatorRootEntityType);
    }

    @CheckForNull
    public EntityType getNavigatorRootEntityType() {
        return this._navigatorRootEntityType;
    }

    @Nonnull
    @CheckReturnValue
    public SearchParameters withNavigatorRootEntityType(EntityType navigatorRootEntityType) {
        return new SearchParameters(this._searchString, this._filter, this._context, this._contextId, (List<EntityId>)this._contextHierarchy, this._sortType, (Set<? extends SubFilter>)this._subfilter, this._searchProviderId, this._searchFacets, this._token, this._isNavigatorSearch, navigatorRootEntityType);
    }

    @ParametersAreNonnullByDefault
    public static interface SearchParametersChangedListener {
        public void onSearchParametersChanged(SearchParameters var1);
    }
}

