/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.shared.model;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.SearchConfigurationProvider;
import de.justsoftware.onx.searchnew.shared.model.SearchContext;
import de.justsoftware.onx.searchnew.shared.model.SearchFacet;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public abstract class SearchContextFacet
implements SearchFacet {
    private static final long serialVersionUID = 1L;
    protected SearchContext _searchContext;

    @Deprecated
    public SearchContextFacet() {
    }

    public SearchContextFacet(SearchContext searchContext) {
        this._searchContext = searchContext;
    }

    @Nonnull
    public SearchContext getSearchContext() {
        return this._searchContext;
    }

    @Override
    public String getFacetName() {
        return this.getSearchContext().name();
    }

    @Override
    public Predicate<FilterType> applyForFilterType(SearchConfigurationProvider searchConfigurationProvider) {
        return Predicates.alwaysTrue();
    }

    @Override
    public boolean applyWithoutFilterType(SearchConfigurationProvider searchConfigurationProvider) {
        return true;
    }

    public static Function<SearchContext, SearchFacet> forContextFunction(final @Nullable EntityId entityId, final @Nullable PersonId userId) {
        return new NullPermeableFunction<SearchContext, SearchFacet>(){

            @Override
            protected SearchContextFacet applySafe(SearchContext input) {
                return (SearchContextFacet)SearchContextFacet.forContext(input, entityId, userId).orNull();
            }
        };
    }

    public static Optional<SearchContextFacet> forContext(SearchContext searchContext, final @Nullable EntityId entityId, final @Nullable PersonId userId) {
        return searchContext.accept(new SearchContext.VisitorFunction<Optional<SearchContextFacet>>(){

            @Override
            public final Optional<SearchContextFacet> visitEntirePlatform() {
                return Optional.of((Object)new AllContentSearchFacet());
            }

            @Override
            public final Optional<SearchContextFacet> visitSubscription() {
                return userId != null ? Optional.of((Object)new MySubscriptionsSearchFacet(userId)) : Optional.absent();
            }

            @Override
            public final Optional<SearchContextFacet> visitMember() {
                return userId != null ? Optional.of((Object)new MemberRoleSearchFacet(userId)) : Optional.absent();
            }

            @Override
            public final Optional<SearchContextFacet> visitAdmin() {
                return userId != null ? Optional.of((Object)new AdminRoleSearchFacet(userId)) : Optional.absent();
            }

            @Override
            public final Optional<SearchContextFacet> visitMyContent() {
                return userId != null ? Optional.of((Object)new MyContentSearchFacet(userId)) : Optional.absent();
            }

            @Override
            public final Optional<SearchContextFacet> visitEntity() {
                return entityId != null ? Optional.of((Object)new EntityBasedSearchContextFacet(entityId, SearchContext.ENTITY)) : Optional.absent();
            }

            @Override
            public final Optional<SearchContextFacet> visitEntityAndSubEntities() {
                return entityId != null ? Optional.of((Object)new EntityBasedSearchContextFacet(entityId, SearchContext.ENTITY_AND_SUBENTITIES)) : Optional.absent();
            }
        });
    }

    @ParametersAreNonnullByDefault
    public static final class EntityBasedSearchContextFacet
    extends SearchContextFacet {
        private static final long serialVersionUID = 1L;
        private EntityId _entityId;

        @Deprecated
        public EntityBasedSearchContextFacet() {
        }

        public EntityBasedSearchContextFacet(EntityId entityId, SearchContext searchContext) {
            super(searchContext);
            this._entityId = entityId;
        }

        @Nonnull
        public EntityId getEntityId() {
            return this._entityId;
        }

        public boolean isIncludeSubentities() {
            return this.getSearchContext() == SearchContext.ENTITY_AND_SUBENTITIES;
        }

        @Override
        public <R> R accept(SearchFacet.SearchFacetVisitor<R> visitor) {
            return visitor.visitEntityContext(this);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this._searchContext, this._entityId});
        }

        public final boolean equals(Object obj) {
            return this == obj || obj != null && this.getClass().equals(obj.getClass()) && Objects.equal((Object)this._entityId, (Object)((EntityBasedSearchContextFacet)obj)._entityId) && Objects.equal((Object)((Object)this._searchContext), (Object)((Object)((SearchContextFacet)obj)._searchContext));
        }
    }

    @ParametersAreNonnullByDefault
    public static final class AdminRoleSearchFacet
    extends SearchContextFacet {
        private static final long serialVersionUID = 1L;
        private PersonId _userId;

        @Deprecated
        public AdminRoleSearchFacet() {
        }

        public AdminRoleSearchFacet(PersonId userId) {
            super(SearchContext.ADMIN);
            this._userId = userId;
        }

        @Override
        public <R> R accept(SearchFacet.SearchFacetVisitor<R> visitor) {
            return visitor.visitAdminRole(this);
        }

        @Nonnull
        public PersonId getUserId() {
            return this._userId;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this._searchContext, this._userId});
        }

        public final boolean equals(Object obj) {
            return this == obj || obj != null && this.getClass().equals(obj.getClass()) && Objects.equal((Object)this._userId, (Object)((AdminRoleSearchFacet)obj)._userId) && Objects.equal((Object)((Object)this._searchContext), (Object)((Object)((SearchContextFacet)obj)._searchContext));
        }
    }

    @ParametersAreNonnullByDefault
    public static final class MemberRoleSearchFacet
    extends SearchContextFacet {
        private static final long serialVersionUID = 1L;
        private PersonId _userId;

        @Deprecated
        public MemberRoleSearchFacet() {
        }

        public MemberRoleSearchFacet(PersonId userId) {
            super(SearchContext.MEMBER);
            this._userId = userId;
        }

        @Override
        public <R> R accept(SearchFacet.SearchFacetVisitor<R> visitor) {
            return visitor.visitMemberRole(this);
        }

        @Nonnull
        public PersonId getUserId() {
            return this._userId;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this._searchContext, this._userId});
        }

        public final boolean equals(Object obj) {
            return this == obj || obj != null && this.getClass().equals(obj.getClass()) && Objects.equal((Object)this._userId, (Object)((MemberRoleSearchFacet)obj)._userId) && Objects.equal((Object)((Object)this._searchContext), (Object)((Object)((SearchContextFacet)obj)._searchContext));
        }
    }

    @ParametersAreNonnullByDefault
    public static final class MySubscriptionsSearchFacet
    extends SearchContextFacet {
        private static final long serialVersionUID = 1L;
        private PersonId _userId;

        @Deprecated
        public MySubscriptionsSearchFacet() {
        }

        public MySubscriptionsSearchFacet(PersonId userId) {
            super(SearchContext.SUBSCRIPTION);
            this._userId = userId;
        }

        @Override
        public <R> R accept(SearchFacet.SearchFacetVisitor<R> visitor) {
            return visitor.visitMySubscriptions(this);
        }

        @Nonnull
        public PersonId getUserId() {
            return this._userId;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this._searchContext, this._userId});
        }

        public final boolean equals(Object obj) {
            return this == obj || obj != null && this.getClass().equals(obj.getClass()) && Objects.equal((Object)this._userId, (Object)((MySubscriptionsSearchFacet)obj)._userId) && Objects.equal((Object)((Object)this._searchContext), (Object)((Object)((SearchContextFacet)obj)._searchContext));
        }
    }

    @ParametersAreNonnullByDefault
    public static final class MyContentSearchFacet
    extends SearchContextFacet {
        private static final long serialVersionUID = 1L;
        private PersonId _userId;

        @Deprecated
        public MyContentSearchFacet() {
        }

        public MyContentSearchFacet(PersonId userId) {
            super(SearchContext.MY_CONTENT);
            this._userId = userId;
        }

        @Override
        public <R> R accept(SearchFacet.SearchFacetVisitor<R> visitor) {
            return visitor.visitMyContent(this);
        }

        @Nonnull
        public PersonId getUserId() {
            return this._userId;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this._searchContext, this._userId});
        }

        public final boolean equals(Object obj) {
            return this == obj || obj != null && this.getClass().equals(obj.getClass()) && Objects.equal((Object)this._userId, (Object)((MyContentSearchFacet)obj)._userId) && Objects.equal((Object)((Object)this._searchContext), (Object)((Object)((SearchContextFacet)obj)._searchContext));
        }
    }

    @ParametersAreNonnullByDefault
    public static final class AllContentSearchFacet
    extends SearchContextFacet {
        private static final long serialVersionUID = 1L;

        private AllContentSearchFacet() {
            super(SearchContext.ENTIRE_PLATFORM);
        }

        @Override
        public <R> R accept(SearchFacet.SearchFacetVisitor<R> visitor) {
            return visitor.visitAllContent(this);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this._searchContext});
        }

        public final boolean equals(Object obj) {
            return this == obj || obj != null && this.getClass().equals(obj.getClass()) && Objects.equal((Object)((Object)this._searchContext), (Object)((Object)((SearchContextFacet)obj)._searchContext));
        }
    }
}

