/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.shared.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypes;
import de.justsoftware.onx.searchnew.shared.model.SearchConfigurationProvider;
import de.justsoftware.onx.searchnew.shared.model.SearchFacet;
import de.justsoftware.onx.util.shared.NullIsFalsePredicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityStatusSearchFacet
implements SearchFacet {
    private static final long serialVersionUID = 1L;
    private EntityType _entityType;

    @Deprecated
    public EntityStatusSearchFacet() {
    }

    public EntityStatusSearchFacet(EntityType entityType) {
        this._entityType = entityType;
    }

    @Nonnull
    public EntityType getEntityType() {
        return this._entityType;
    }

    @Override
    public Predicate<FilterType> applyForFilterType(SearchConfigurationProvider searchConfigurationProvider) {
        return Predicates.compose((Predicate)Predicates.and((Predicate)Predicates.equalTo((Object)this._entityType), this.getStatusFilterEnabledPredicate(searchConfigurationProvider)), FilterTypes.TO_ENTITY_TYPE);
    }

    @Nonnull
    private Predicate<EntityType> getStatusFilterEnabledPredicate(final SearchConfigurationProvider searchConfigurationProvider) {
        return new NullIsFalsePredicate<EntityType>(){

            @Override
            public boolean applySafe(EntityType input) {
                return searchConfigurationProvider.isShowEntityStatusSearchFilter(input);
            }
        };
    }

    @Override
    public boolean applyWithoutFilterType(SearchConfigurationProvider searchConfigurationProvider) {
        return false;
    }

    @Override
    public <R> R accept(SearchFacet.SearchFacetVisitor<R> visitor) {
        return visitor.visitEntityStatus(this);
    }

    @Override
    public String getFacetName() {
        return "ENTITY_STATUS";
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this._entityType});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityStatusSearchFacet other = (EntityStatusSearchFacet)obj;
        return Objects.equal((Object)this._entityType, (Object)other.getEntityType());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("entityType", (Object)this._entityType).toString();
    }
}

