/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.shared.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeId;
import de.justsoftware.onx.common.shared.model.attributes.EntityDynamicAttributesUtil;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypes;
import de.justsoftware.onx.searchnew.shared.model.SearchConfigurationProvider;
import de.justsoftware.onx.searchnew.shared.model.SearchFacet;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityDynamicAttributeSearchFacet
implements SearchFacet {
    private static final long serialVersionUID = 1L;
    private DynamicAttributeId _dynamicAttributeId;
    private EntityType _entityType;

    @Deprecated
    public EntityDynamicAttributeSearchFacet() {
    }

    public EntityDynamicAttributeSearchFacet(DynamicAttributeId dynamicAttributeId, EntityType entityType) {
        this._dynamicAttributeId = dynamicAttributeId;
        this._entityType = entityType;
    }

    @Nonnull
    public DynamicAttributeId getDynamicAttributeId() {
        return this._dynamicAttributeId;
    }

    @Nonnull
    public EntityType getEntityType() {
        return this._entityType;
    }

    @Override
    public Predicate<FilterType> applyForFilterType(SearchConfigurationProvider searchConfigurationProvider) {
        return Predicates.compose((Predicate)Predicates.equalTo((Object)this._entityType), FilterTypes.TO_ENTITY_TYPE);
    }

    @Override
    public boolean applyWithoutFilterType(SearchConfigurationProvider searchConfigurationProvider) {
        return false;
    }

    @Override
    public <R> R accept(SearchFacet.SearchFacetVisitor<R> visitor) {
        return visitor.visitDynamicEntityAttribute(this);
    }

    @Override
    public String getFacetName() {
        return EntityDynamicAttributesUtil.toFacetFieldName(this.getDynamicAttributeId(), this._entityType);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this._dynamicAttributeId, this._entityType});
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof EntityDynamicAttributeSearchFacet && Objects.equal((Object)this._dynamicAttributeId, (Object)((EntityDynamicAttributeSearchFacet)obj)._dynamicAttributeId) && Objects.equal((Object)this._entityType, (Object)((EntityDynamicAttributeSearchFacet)obj)._entityType);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("dynamicAttributeId", (Object)this._dynamicAttributeId).add("entityType", (Object)this._entityType).toString();
    }
}

