/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.shared.model;

import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.searchnew.shared.model.DriveDocumentSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.HasExpirationDate;
import de.justsoftware.onx.searchnew.shared.model.SearchSuggestModelVisitor;
import de.justsoftware.onx.searchnew.shared.model.SuggestModel;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DriveDocumentSuggest
extends SuggestModel<DriveDocumentId, ItemType>
implements HasExpirationDate {
    private static final long serialVersionUID = 1L;
    private DriveDocumentSearchResultBadgeModel.DocumentType _documentType;
    private ItemId _parentId;
    private String _mimeType;
    private long _fileSize = 0L;
    private Date _expirationDate;
    private Date _modifyDate;

    public DriveDocumentSuggest(DriveDocumentSearchResultBadgeModel.DocumentType docType) {
        this._documentType = docType;
    }

    @Deprecated
    public DriveDocumentSuggest() {
    }

    @Override
    public <T> T visit(SearchSuggestModelVisitor<T> visitor) {
        return visitor.visitDriveDocument(this);
    }

    @Nonnull
    public DriveDocumentSearchResultBadgeModel.DocumentType getDocumentType() {
        return this._documentType;
    }

    @CheckForNull
    public String getMimeType() {
        return this._mimeType;
    }

    public void setMimeType(@Nullable String mimeType) {
        this._mimeType = mimeType;
    }

    @CheckForNull
    public ItemId getParentId() {
        return this._parentId;
    }

    public void setParentId(@Nullable ItemId parentId) {
        this._parentId = parentId;
    }

    @Override
    public Date getExpirationDate() {
        return Dates.clone(this._expirationDate);
    }

    public void setExpirationDate(@Nullable Date expirationDate) {
        this._expirationDate = Dates.clone(expirationDate);
    }

    public long getFileSize() {
        return this._fileSize;
    }

    public void setFileSize(long fileSize) {
        this._fileSize = fileSize;
    }

    @CheckForNull
    public Date getModifyDate() {
        return Dates.clone(this._modifyDate);
    }

    public void setModifyDate(@Nullable Date modifyDate) {
        this._modifyDate = Dates.clone(modifyDate);
    }
}

