/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.shared.model;

import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.common.shared.util.ValueOfMap;
import de.justsoftware.onx.container.shared.model.EntityDurationTimeOption;
import de.justsoftware.onx.container.shared.model.EntityStatusId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.searchnew.shared.model.SearchConfigurationProvider;
import javax.annotation.Nonnull;

public class DelegatingSearchConfigurationProvider
implements SearchConfigurationProvider {
    private final SearchConfigurationProvider _delegate;
    private final ValueOfMap<EntityType, EntityDurationTimeOption> _durationTimeOption = new ValueOfMap<EntityType, EntityDurationTimeOption>(){

        @Override
        protected EntityDurationTimeOption create(EntityType key) {
            return DelegatingSearchConfigurationProvider.this._delegate.getDurationTimeOption(key);
        }
    };
    private final ValueOfMap<EntityType, Boolean> _showEntityStatusSearchFilter = new ValueOfMap<EntityType, Boolean>(){

        @Override
        protected Boolean create(EntityType key) {
            return DelegatingSearchConfigurationProvider.this._delegate.isShowEntityStatusSearchFilter(key);
        }
    };
    private final ValueOfMap<EntityType, Boolean> _showArchivedSearchFilter = new ValueOfMap<EntityType, Boolean>(){

        @Override
        protected Boolean create(EntityType key) {
            return DelegatingSearchConfigurationProvider.this._delegate.isShowArchivedSearchFilter(key);
        }
    };
    private final ValueOfMap<EntityType, Boolean> _sortableByExpirationDate = new ValueOfMap<EntityType, Boolean>(){

        @Override
        protected Boolean create(EntityType key) {
            return DelegatingSearchConfigurationProvider.this._delegate.isSortableByExpirationDate(key);
        }
    };
    private final ValueOfMap<EntityType, ImmutableSetMultimap<Boolean, EntityStatusId>> _entityStatusByArchivedFlag = new ValueOfMap<EntityType, ImmutableSetMultimap<Boolean, EntityStatusId>>(){

        @Override
        protected ImmutableSetMultimap<Boolean, EntityStatusId> create(EntityType key) {
            return DelegatingSearchConfigurationProvider.this._delegate.getEntityStatusByArchivedFlag(key);
        }
    };
    private final ValueOfMap<EntityType, Boolean> _showTagSearchFilterForEntities = new ValueOfMap<EntityType, Boolean>(){

        @Override
        protected Boolean create(EntityType key) {
            return DelegatingSearchConfigurationProvider.this._delegate.isShowTagSearchFilterForEntities(key);
        }
    };
    private Boolean _showArchivedSearchFilterAnyEntityType;
    private Boolean _showTagSearchFilterAnyFilterType;
    private Boolean _showTagSearchFilterForDocuments;
    private Boolean _showPersonRoleFilter;

    public DelegatingSearchConfigurationProvider(@Nonnull SearchConfigurationProvider delegate) {
        this._delegate = delegate;
    }

    @Override
    public EntityDurationTimeOption getDurationTimeOption(EntityType entityType) {
        return this._durationTimeOption.get(entityType);
    }

    @Override
    public boolean isShowEntityStatusSearchFilter(EntityType entityType) {
        return this._showEntityStatusSearchFilter.get(entityType);
    }

    @Override
    public boolean isShowArchivedSearchFilter(EntityType entityType) {
        return this._showArchivedSearchFilter.get(entityType);
    }

    @Override
    public boolean isShowArchivedSearchFilterAnyEntityType() {
        if (this._showArchivedSearchFilterAnyEntityType == null) {
            this._showArchivedSearchFilterAnyEntityType = this._delegate.isShowArchivedSearchFilterAnyEntityType();
        }
        return this._showArchivedSearchFilterAnyEntityType;
    }

    @Override
    public boolean isSortableByExpirationDate(EntityType entityType) {
        return this._sortableByExpirationDate.get(entityType);
    }

    @Override
    public ImmutableSetMultimap<Boolean, EntityStatusId> getEntityStatusByArchivedFlag(EntityType entityType) {
        return this._entityStatusByArchivedFlag.get(entityType);
    }

    @Override
    public boolean isShowTagSearchFilterAnyFilterType() {
        if (this._showTagSearchFilterAnyFilterType == null) {
            this._showTagSearchFilterAnyFilterType = this._delegate.isShowTagSearchFilterAnyFilterType();
        }
        return this._showTagSearchFilterAnyFilterType;
    }

    @Override
    public boolean isShowTagSearchFilterForEntities(EntityType entityType) {
        return this._showTagSearchFilterForEntities.get(entityType);
    }

    @Override
    public boolean isShowTagSearchFilterForDocuments() {
        if (this._showTagSearchFilterForDocuments == null) {
            this._showTagSearchFilterForDocuments = this._delegate.isShowTagSearchFilterForDocuments();
        }
        return this._showTagSearchFilterForDocuments;
    }

    @Override
    public boolean isShowPersonRoleFilter() {
        if (this._showPersonRoleFilter == null) {
            this._showPersonRoleFilter = this._delegate.isShowPersonRoleFilter();
        }
        return this._showPersonRoleFilter;
    }

    @Override
    public boolean isShowSearchContextFilter() {
        return this._delegate.isShowSearchContextFilter();
    }

    public String toString() {
        return this._delegate.toString();
    }
}

