/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.shared.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.message.shared.model.ConversationType;
import de.justsoftware.onx.searchnew.shared.model.AbstractSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.FederatedSearchResultEntryVisitor;
import de.justsoftware.onx.searchnew.shared.model.SearchResultBadgeVisitor;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ConversationSearchResultBadgeModel
extends AbstractSearchResultBadgeModel<ConversationId, ItemType> {
    public static final String FOUND_IN_CONTENT = "content";
    public static final String FOUND_IN_PARTICIPANTS = "participants";
    private static final long serialVersionUID = 1L;
    private ConversationType _conversationType;
    private ImmutableSet<PersonId> _participants;
    private ImmutableSet<PersonId> _deletedParticipants;

    @CheckForNull
    public ConversationType getConversationType() {
        return this._conversationType;
    }

    public void setConversationType(ConversationType conversationType) {
        this._conversationType = conversationType;
    }

    @Override
    public <R> R visit(SearchResultBadgeVisitor<R> visitor) {
        return visitor.visitConversation(this);
    }

    @Override
    public <V> V invite(FederatedSearchResultEntryVisitor<V> visitor) {
        return visitor.visitSearchResultBadgeModel(this);
    }

    @Nonnull
    public ImmutableSet<PersonId> getParticipants() {
        return this._participants != null ? this._participants : ImmutableSet.of();
    }

    public void setParticipants(ImmutableSet<PersonId> participants) {
        this._participants = participants;
    }

    @Nonnull
    public ImmutableSet<PersonId> getDeletedParticipants() {
        return this._deletedParticipants != null ? this._deletedParticipants : ImmutableSet.of();
    }

    public void setDeletedParticipants(ImmutableSet<PersonId> deletedParticipants) {
        this._deletedParticipants = deletedParticipants;
    }

    @Override
    @Nonnull
    protected MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("conversationType", (Object)this._conversationType).add(FOUND_IN_PARTICIPANTS, this._participants != null ? Integer.valueOf(this._participants.size()) : null).add("deletedParticipants", this._deletedParticipants != null ? Integer.valueOf(this._deletedParticipants.size()) : null);
    }
}

