/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.shared.model;

import de.justsoftware.onx.chat.shared.model.ChatId;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.AbstractUUIDBasedItemId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.NewsChannelId;
import de.justsoftware.onx.container.shared.model.NewsPostId;
import de.justsoftware.onx.container.shared.model.SearchableId;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.wiki.shared.model.ArticleId;
import de.justsoftware.onx.wiki.shared.model.ChapterId;
import de.justsoftware.onx.wiki.shared.model.WikiId;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class CompoundIdStringUtil {
    private static final String DELIMITER = ",";

    private CompoundIdStringUtil() {
    }

    public static String getCompoundIdSearchStringFromSearchableId(SearchableId id) {
        return id.accept(new SearchableId.Visitor<String>(){

            @Override
            public String visit(PersonId personId) {
                return CompoundIdStringUtil.getCompoundIdSearchStringFromGlobalId(personId.asProfileId());
            }

            @Override
            public String visit(EntityId entityId) {
                return CompoundIdStringUtil.getCompoundIdSearchStringFromGlobalId(entityId);
            }

            @Override
            public String visit(WorkstreamMessageId workstreamMessageId) {
                return CompoundIdStringUtil.getCompoundIdSearchStringFromGlobalId(workstreamMessageId);
            }

            @Override
            public String visit(ConversationId conversationId) {
                return CompoundIdStringUtil.getCompoundIdSearchStringFromUUIDBasedItemId(conversationId);
            }

            @Override
            public String visit(ChatId chatId) {
                return CompoundIdStringUtil.getCompoundIdSearchStringFromUUIDBasedItemId(chatId);
            }

            @Override
            public String visit(DriveDocumentId driveDocumentId) {
                return CompoundIdStringUtil.getCompoundIdSearchString(driveDocumentId.getId(), driveDocumentId.getType().name());
            }

            @Override
            public String visit(WikiId wikiId) {
                return CompoundIdStringUtil.getCompoundIdSearchString(wikiId.getId(), wikiId.getType().name());
            }

            @Override
            public String visit(ChapterId chapterId) {
                return CompoundIdStringUtil.getCompoundIdSearchString(chapterId.getId(), chapterId.getType().name());
            }

            @Override
            public String visit(ArticleId articleId) {
                return CompoundIdStringUtil.getCompoundIdSearchString(articleId.getId(), articleId.getType().name());
            }

            @Override
            public String visit(NewsPostId id) {
                return CompoundIdStringUtil.getCompoundIdSearchString(id.getId(), id.getType().name());
            }

            @Override
            @Nonnull
            public String visit(NewsChannelId id) {
                return CompoundIdStringUtil.getCompoundIdSearchString(id.getId(), id.getType().name());
            }
        });
    }

    @Nonnull
    public static String parseType(String compoundId) {
        return compoundId.substring(0, compoundId.indexOf(DELIMITER));
    }

    @Nonnull
    public static String parseStringId(String compoundId) {
        return compoundId.substring(compoundId.indexOf(DELIMITER) + 1, compoundId.length());
    }

    @Nonnull
    public static String getCompoundIdSearchString(String id, String type) {
        return type + DELIMITER + id;
    }

    @Nonnull
    private static String getCompoundIdSearchStringFromGlobalId(GlobalId globalId) {
        return CompoundIdStringUtil.getCompoundIdSearchString(String.valueOf(globalId.getId()), globalId.getType().name());
    }

    @Nonnull
    public static String getCompoundIdSearchStringFromUUIDBasedItemId(AbstractUUIDBasedItemId id) {
        return CompoundIdStringUtil.getCompoundIdSearchString(id.getId().toString(), id.getType().name());
    }
}

