/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStandardResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.common.shared.util.Numbers;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.searchnew.business.model.SearchIndexType;
import de.justsoftware.onx.searchnew.integration.persistence.SearchIndexQueueDAO;
import de.justsoftware.onx.searchnew.shared.server.model.DBSearchIndexQueueEntry;
import de.justsoftware.onx.searchnew.shared.server.model.SearchIndexQueueEntryId;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

@Service
public class IbatisSearchIndexQueueDAO
implements SearchIndexQueueDAO {
    private final TransactionHelper _transactionHelper;
    private final IbatisStatementBuilder _ibatisBuilder;

    @Autowired
    @ParametersAreNonnullByDefault
    public IbatisSearchIndexQueueDAO(StatementBuilderFactory statementBuilderFactory, TransactionHelper transactionHelper) {
        this._ibatisBuilder = statementBuilderFactory.ibatistStatementBuilder("SearchIndexQueue");
        this._transactionHelper = transactionHelper;
    }

    @Override
    public void create(Set<DBSearchIndexQueueEntry> entries) {
        if (!entries.isEmpty()) {
            this._ibatisBuilder.insert("insertEntries").param(IbatisDAOUtil.toIbatisList(entries));
        }
    }

    @Override
    public List<DBSearchIndexQueueEntry> getEntries(final int maxResults, final DateTime lastProcessedBefore) {
        return this._transactionHelper.doInTransaction(new TransactionCallback<List<DBSearchIndexQueueEntry>>(){

            public List<DBSearchIndexQueueEntry> doInTransaction(TransactionStatus status) {
                ImmutableList entriesToProcess = ((IbatisStandardResultBuilder)IbatisSearchIndexQueueDAO.this._ibatisBuilder.select("getEntries").param("beforeTimestamp", new DateWithoutTimezone(lastProcessedBefore.toDate()))).limit(maxResults).toList();
                if (!entriesToProcess.isEmpty()) {
                    ImmutableSet entryIds = FluentIterable.from((Iterable)entriesToProcess).transform(DBSearchIndexQueueEntry.TO_ID).filter(Predicates.notNull()).toSet();
                    IbatisSearchIndexQueueDAO.this._ibatisBuilder.update("markEntriesAsInProgress").partition("ids", entryIds, "currentTimestamp", new DateWithoutTimezone(), "inProgress", Boolean.TRUE);
                }
                return entriesToProcess;
            }
        });
    }

    @Override
    public void removeInProgressFlag(ImmutableSet<SearchIndexQueueEntryId> entryIds) {
        this._ibatisBuilder.update("markEntriesAsInProgress").partition("ids", entryIds, "currentTimestamp", new DateWithoutTimezone(), "inProgress", Boolean.FALSE);
    }

    @Override
    public int delete(Set<SearchIndexQueueEntryId> ids) {
        return (Integer)this._ibatisBuilder.delete("deleteEntries").partition(ids);
    }

    @Override
    public void deleteByItemType(Set<ItemType> itemTypes) {
        this._ibatisBuilder.delete("deleteEntriesByType").partition(itemTypes);
    }

    @Override
    public void deleteByEntityType(Set<EntityType> entityTypes) {
        this._ibatisBuilder.delete("deleteEntriesByEntityType").partition(entityTypes);
    }

    @Override
    public void insertEntriesForEntityType(Set<EntityType> entityTypes) {
        this._ibatisBuilder.insert("insertAllEntitiesOfType").partition(entityTypes);
    }

    @Override
    public void insertAllProfiles() {
        this._ibatisBuilder.insert("insertAllProfiles").noParam();
    }

    @Override
    public void insertAllMicroblogs() {
        this._ibatisBuilder.insert("insertAllMicroblogs").noParam();
    }

    @Override
    public int deleteEntriesOlderThan(SetMultimap<SearchIndexType, ? extends ItemId> entries, DateTime olderThan) {
        return (Integer)this._ibatisBuilder.delete("deleteEntriesOlderThan").partition("entries", entries.entries(), "olderThan", olderThan.toDate());
    }

    @Override
    public int deleteEntriesOlderThan(Set<? extends ItemId> entries, DateTime olderThan) {
        return (Integer)this._ibatisBuilder.delete("deleteAllEntriesOlderThan").partition("entries", entries, "olderThan", olderThan.toDate());
    }

    @Override
    public long getQueueSize() {
        return Numbers.longValue((Number)((IbatisStandardResultBuilder)this._ibatisBuilder.select("getQueueSize").noParam()).singleObject());
    }

    @Override
    public ImmutableSetMultimap<SearchIndexType, ItemId> getAllEntriesForTest() {
        return ((IbatisStandardResultBuilder)this._ibatisBuilder.select("getAllEntriesForTest").noParam()).asSetMultimap(DBSearchIndexQueueEntry.TO_INDEX_TYPE, DBSearchIndexQueueEntry.TO_ITEM_ID);
    }
}

