/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisPartitionResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStandardResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.message.shared.model.ConversationId;
import de.justsoftware.onx.searchnew.business.model.ConversationIndexType;
import de.justsoftware.onx.searchnew.integration.persistence.ConversationSearchIndexQueueDAO;
import de.justsoftware.onx.searchnew.shared.server.model.ConversationSearchIndexQueueEntryId;
import de.justsoftware.onx.searchnew.shared.server.model.DBConversationSearchIndexQueueEntry;
import de.justsoftware.toolbox.clock.Clock;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IbatisConversationSearchIndexQueueDAO
implements ConversationSearchIndexQueueDAO {
    private final IbatisStatementBuilder _ibatisBuilder;
    private final Clock _clock;
    private final Random _random = new Random();

    @Autowired
    @ParametersAreNonnullByDefault
    public IbatisConversationSearchIndexQueueDAO(StatementBuilderFactory statementBuilderFactory, Clock clock) {
        this._ibatisBuilder = statementBuilderFactory.ibatistStatementBuilder("ConversationSearchQueue");
        this._clock = clock;
    }

    @Override
    public void create(Set<DBConversationSearchIndexQueueEntry> entries) {
        if (!entries.isEmpty()) {
            this._ibatisBuilder.insert("insertItems").param(IbatisDAOUtil.toIbatisList(entries));
        }
    }

    @Override
    public void insertAllConversations(ConversationIndexType indexType) {
        this._ibatisBuilder.insert("insertAllConversations").param(ImmutableMap.of((Object)"indexType", (Object)indexType.name()));
    }

    @Override
    public void deleteAll() {
        this._ibatisBuilder.delete("deleteAll").noParam();
    }

    @Override
    public long getQueueSize() {
        Integer result = (Integer)((IbatisStandardResultBuilder)this._ibatisBuilder.select("getQueueSize").noParam()).singleObject();
        return result != null ? (long)result.intValue() : 0L;
    }

    @Override
    public ImmutableList<DBConversationSearchIndexQueueEntry> fetchNext(int count) {
        Long lockId;
        ImmutableSet nextIds;
        int numUpdated;
        do {
            if ((nextIds = this._ibatisBuilder.select("getNextItems").param(count).asSet()).isEmpty()) {
                return ImmutableList.of();
            }
            lockId = this._random.nextLong();
        } while ((numUpdated = ((Integer)this._ibatisBuilder.update("updateMarkInProgress").partition("ids", nextIds, (Map<String, ?>)ImmutableMap.of((Object)"lockId", (Object)lockId, (Object)"modifiedAt", (Object)this._clock.now()))).intValue()) == 0);
        if (numUpdated < count) {
            nextIds = ((IbatisPartitionResultBuilder)this._ibatisBuilder.select("getLockedItemIds").partition("ids", nextIds, (Map<String, ?>)ImmutableMap.of((Object)"lockId", (Object)lockId))).asSet();
        }
        return ((IbatisPartitionResultBuilder)this._ibatisBuilder.select("getByIds").partition(nextIds)).asList();
    }

    @Override
    public void deleteByIds(Iterable<ConversationSearchIndexQueueEntryId> ids) {
        this._ibatisBuilder.delete("deleteByIds").partition(ImmutableSet.copyOf(ids));
    }

    @Override
    public void unlockStuckIds(long minProgressDuration) {
        DateTime maxProgressDate = this._clock.now().minus(minProgressDuration);
        this._ibatisBuilder.update("unlockStuckEvents").param(ImmutableMap.of((Object)"modifiedAt", (Object)this._clock.now(), (Object)"maxProgressDate", (Object)maxProgressDate));
    }

    @Override
    public void deleteByConversationId(ImmutableSet<ConversationId> conversationIds) {
        this._ibatisBuilder.delete("deleteConversationEventsByConversationId").partition(conversationIds);
        this._ibatisBuilder.delete("deleteMessageEventsByConversationId").partition(conversationIds);
    }
}

