/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.integration.persistence;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.searchnew.business.model.SearchIndexType;
import de.justsoftware.onx.searchnew.shared.server.model.DBSearchIndexQueueEntry;
import de.justsoftware.onx.searchnew.shared.server.model.SearchIndexQueueEntryId;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public interface SearchIndexQueueDAO {
    public void create(Set<DBSearchIndexQueueEntry> var1);

    public void insertEntriesForEntityType(Set<EntityType> var1);

    public void insertAllProfiles();

    public void insertAllMicroblogs();

    @Nonnull
    public List<DBSearchIndexQueueEntry> getEntries(int var1, DateTime var2);

    public int delete(Set<SearchIndexQueueEntryId> var1);

    public int deleteEntriesOlderThan(SetMultimap<SearchIndexType, ? extends ItemId> var1, DateTime var2);

    public int deleteEntriesOlderThan(Set<? extends ItemId> var1, DateTime var2);

    public void deleteByItemType(Set<ItemType> var1);

    public void deleteByEntityType(Set<EntityType> var1);

    public long getQueueSize();

    @Nonnull
    public ImmutableSetMultimap<SearchIndexType, ItemId> getAllEntriesForTest();

    public void removeInProgressFlag(ImmutableSet<SearchIndexQueueEntryId> var1);
}

