/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.common.shared.model.Type;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.searchnew.business.WikiSearchHandler;
import de.justsoftware.onx.searchnew.business.impl.AbstractSearchHandler;
import de.justsoftware.onx.searchnew.business.model.CompoundId;
import de.justsoftware.onx.searchnew.shared.model.CommonSearchResultModel;
import de.justsoftware.onx.searchnew.shared.model.CompoundIdStringUtil;
import de.justsoftware.onx.searchnew.shared.model.WikiSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.WikiSuggest;
import de.justsoftware.onx.wiki.shared.model.WikiId;
import javax.annotation.CheckForNull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class WikiSearchHandlerImpl
extends AbstractSearchHandler<WikiId, ItemType>
implements WikiSearchHandler {
    private static final String FOUND_IN_FIELD_DELIMITER = "... ";

    @Override
    public ImmutableMap<CompoundId, WikiSearchResultBadgeModel> createSearchResultBadgeModel(Iterable<? extends CommonSearchResultModel> searchResults, AuthorizationCheckContextWithUserId authorizationContext) {
        return FluentIterable.from(searchResults).transform(this::createSearchResultBadgeModel).filter(Predicates.notNull()).uniqueIndex(result -> CompoundId.of((WikiId)result.getId()));
    }

    @Override
    public ImmutableMap<CompoundId, WikiSuggest> createSearchResultSuggestModel(Iterable<? extends CommonSearchResultModel> searchResults, AuthorizationCheckContextWithUserId authorizationContext) {
        return FluentIterable.from(searchResults).transform(this::createSearchResultSuggestModel).filter(Predicates.notNull()).uniqueIndex(result -> CompoundId.of((WikiId)result.getId()));
    }

    @CheckForNull
    private WikiSuggest createSearchResultSuggestModel(CommonSearchResultModel searchResult) {
        WikiSuggest suggest = new WikiSuggest();
        this.applySearchData(searchResult, ItemType.WIKI_WIKI, suggest);
        return suggest;
    }

    @CheckForNull
    private WikiSearchResultBadgeModel createSearchResultBadgeModel(CommonSearchResultModel searchResult) {
        WikiSearchResultBadgeModel result = new WikiSearchResultBadgeModel();
        result.setId(new WikiId(CompoundIdStringUtil.parseStringId(searchResult.getId())));
        result.setType(ItemType.WIKI_WIKI);
        result.setName(searchResult.getNameSubstring());
        result.setCommonFields(searchResult);
        WikiSearchHandlerImpl.addFoundInData(result, searchResult, FOUND_IN_FIELD_DELIMITER);
        return result;
    }

    private static void addFoundInData(WikiSearchResultBadgeModel searchResultBadgeModel, CommonSearchResultModel searchResultModel, String delimiter) {
        WikiSearchHandlerImpl.addFoundInField("description", searchResultBadgeModel, searchResultModel, delimiter);
    }

    @Override
    protected WikiId createId(String stringId) {
        return new WikiId(CompoundIdStringUtil.parseStringId(stringId));
    }

    @Override
    protected boolean canHandle(Type type) {
        return ItemType.WIKI_WIKI == type;
    }
}

