/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Sets;
import de.justsoftware.onx.authorization.business.StaticPredefinedRole;
import de.justsoftware.onx.container.business.EntityChildrenService;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.events.shared.server.model.UpdateEventTypeVisitor;
import de.justsoftware.onx.searchnew.business.CommonSearchFields;
import de.justsoftware.onx.searchnew.business.criteria.Restrictions;
import de.justsoftware.onx.searchnew.business.model.SearchIndexType;
import de.justsoftware.onx.searchnew.shared.server.model.DBSearchIndexQueueEntry;
import de.justsoftware.onx.workstream.business.WorkstreamService;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class UpdateEventTypeToDBSearchIndexQueueEntriesVisitor
implements UpdateEventTypeVisitor<Set<DBSearchIndexQueueEntry>> {
    private final Set<ItemId> _itemIds;
    private final EntityChildrenService _entityChildrenService;
    private final WorkstreamService _workstreamService;
    private final Settings _settings;

    public UpdateEventTypeToDBSearchIndexQueueEntriesVisitor(Set<ItemId> itemIds, EntityChildrenService entityChildrenService, WorkstreamService workstreamService, Settings settings) {
        this._itemIds = itemIds;
        this._entityChildrenService = entityChildrenService;
        this._workstreamService = workstreamService;
        this._settings = settings;
    }

    @Override
    public Set<DBSearchIndexQueueEntry> visitEntityVisibilities() {
        return Sets.union(DBSearchIndexQueueEntry.fromItemIds(this._itemIds, SearchIndexType.VISIBILITIES), this.updateChildren((Set<EntityId>)this.entities(), SearchIndexType.VISIBILITIES));
    }

    @Nonnull
    private Set<DBSearchIndexQueueEntry> updateChildren(Set<EntityId> parents, SearchIndexType ... indexTypes) {
        ImmutableSet<ItemId> children = this._entityChildrenService.getChildrenOfEntities(false, (Iterable<ItemType>)ImmutableSet.of((Object)ItemType.DRIVE_DOCUMENT, (Object)ItemType.WORKSTREAM_MESSAGE), parents, null);
        return DBSearchIndexQueueEntry.fromItemIds(children, indexTypes);
    }

    @Override
    public Set<DBSearchIndexQueueEntry> visitEntityUpdated() {
        return DBSearchIndexQueueEntry.fromItemIds(this._itemIds, SearchIndexType.ALL);
    }

    @Override
    public Set<DBSearchIndexQueueEntry> visitEntityParent() {
        SearchIndexType[] searchIndexTypeArray;
        if (this._settings.isIndexPathEnabled()) {
            SearchIndexType[] searchIndexTypeArray2 = new SearchIndexType[2];
            searchIndexTypeArray2[0] = SearchIndexType.PARENTS;
            searchIndexTypeArray = searchIndexTypeArray2;
            searchIndexTypeArray2[1] = SearchIndexType.PATH;
        } else {
            SearchIndexType[] searchIndexTypeArray3 = new SearchIndexType[1];
            searchIndexTypeArray = searchIndexTypeArray3;
            searchIndexTypeArray3[0] = SearchIndexType.PARENTS;
        }
        SearchIndexType[] searchIndexTypes = searchIndexTypeArray;
        ImmutableSet<EntityId> parents = this.entities();
        ImmutableSet childEntities = ImmutableSet.copyOf((Collection)this._entityChildrenService.getAllEntityChildrenByParentIds(parents).values());
        Sets.SetView allEntities = Sets.union(parents, (Set)childEntities);
        return Sets.union(DBSearchIndexQueueEntry.fromItemIds((Iterable<? extends ItemId>)allEntities, searchIndexTypes), this.updateChildren((Set<EntityId>)allEntities, searchIndexTypes));
    }

    @Override
    public Set<DBSearchIndexQueueEntry> visitEntityName() {
        if (!this._settings.isIndexPathEnabled()) {
            return ImmutableSet.of();
        }
        ImmutableSet<EntityId> parents = this.entities();
        ImmutableSet childEntities = ImmutableSet.copyOf((Collection)this._entityChildrenService.getAllEntityChildrenByParentIds(parents).values());
        Sets.SetView allEntities = Sets.union(parents, (Set)childEntities);
        return Sets.union(DBSearchIndexQueueEntry.fromItemIds((Iterable<? extends ItemId>)childEntities, SearchIndexType.PATH), this.updateChildren((Set<EntityId>)allEntities, SearchIndexType.PATH));
    }

    @Override
    public Set<DBSearchIndexQueueEntry> visitEntityMember() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(DBSearchIndexQueueEntry.fromItemIds(this._itemIds, SearchIndexType.ALL));
        ImmutableSet<EntityId> parents = this.entities();
        ImmutableCollection memberInheritedChildren = this._entityChildrenService.getMemberInheritedEntityChildrenByParentIds(parents).values();
        ImmutableSet.Builder allParentsBuilder = ImmutableSet.builder();
        allParentsBuilder.addAll(parents);
        allParentsBuilder.addAll((Iterable)memberInheritedChildren);
        builder.addAll(DBSearchIndexQueueEntry.fromItemIds((Iterable<? extends ItemId>)memberInheritedChildren, SearchIndexType.ENTITIES_MEMBERSHIP));
        builder.addAll(DBSearchIndexQueueEntry.fromItemIds(this._entityChildrenService.getChildrenOfEntities(true, (Iterable<ItemType>)ImmutableSet.of((Object)ItemType.DOCUMENT, (Object)ItemType.WORKSTREAM_MESSAGE), (Set<EntityId>)allParentsBuilder.build(), null), new SearchIndexType[]{SearchIndexType.VISIBILITIES}));
        builder.addAll(DBSearchIndexQueueEntry.fromItemIds(this._entityChildrenService.getChildrenOfEntities(false, (Iterable<ItemType>)ImmutableSet.of((Object)ItemType.PROFILE), (Set<EntityId>)parents, Restrictions.eq(CommonSearchFields.VISIBILITY_INCLUDED_ITEM_DEPENDANT_ROLES.getFieldName(), StaticPredefinedRole.PERSON_MEMBER_OF_SAME_ENTITY.name())), new SearchIndexType[]{SearchIndexType.VISIBILITIES}));
        builder.addAll(DBSearchIndexQueueEntry.fromItemIds(this._entityChildrenService.getChildrenOfEntities(true, (Iterable<ItemType>)ImmutableSet.of((Object)ItemType.DOCUMENT, (Object)ItemType.WORKSTREAM_MESSAGE), (Set<EntityId>)parents, null), new SearchIndexType[]{SearchIndexType.VISIBILITIES}));
        return builder.build();
    }

    @Override
    public Set<DBSearchIndexQueueEntry> visitEntityAdmin() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(DBSearchIndexQueueEntry.fromItemIds(this._itemIds, SearchIndexType.ALL));
        ImmutableSet<EntityId> parents = this.entities();
        ImmutableSetMultimap<EntityId, EntityId> adminInheritedEntityChildrenByParentIds = this._entityChildrenService.getAdminInheritedEntityChildrenByParentIds(parents);
        ImmutableCollection adminInheritedChildren = adminInheritedEntityChildrenByParentIds.values();
        ImmutableSet.Builder allParentsBuilder = ImmutableSet.builder();
        allParentsBuilder.addAll(parents);
        allParentsBuilder.addAll((Iterable)adminInheritedChildren);
        builder.addAll(DBSearchIndexQueueEntry.fromItemIds((Iterable<? extends ItemId>)adminInheritedChildren, SearchIndexType.ENTITIES_ADMIN));
        ImmutableSet<ItemId> childrenOfEntities = this._entityChildrenService.getChildrenOfEntities(true, (Iterable<ItemType>)ImmutableSet.of((Object)ItemType.DOCUMENT, (Object)ItemType.WORKSTREAM_MESSAGE), (Set<EntityId>)allParentsBuilder.build(), null);
        builder.addAll(DBSearchIndexQueueEntry.fromItemIds(childrenOfEntities, new SearchIndexType[]{SearchIndexType.VISIBILITIES}));
        return builder.build();
    }

    @Override
    public Set<DBSearchIndexQueueEntry> visitProfile() {
        return DBSearchIndexQueueEntry.fromItemIds(this._itemIds, SearchIndexType.ALL);
    }

    @Override
    public Set<DBSearchIndexQueueEntry> visitWorkstream() {
        return DBSearchIndexQueueEntry.fromItemIds(this._itemIds, SearchIndexType.ALL);
    }

    @Override
    public Set<DBSearchIndexQueueEntry> visitProfileVisibilities() {
        return Sets.union(DBSearchIndexQueueEntry.fromItemIds(this._itemIds, SearchIndexType.VISIBILITIES), this.updateProfileChildrenVisibilities());
    }

    @Override
    public Set<DBSearchIndexQueueEntry> visitProfileContact() {
        return Sets.union(DBSearchIndexQueueEntry.fromItemIds(this._itemIds, SearchIndexType.ALL), this.updateProfileChildrenVisibilities());
    }

    @Nonnull
    private ImmutableSet<DBSearchIndexQueueEntry> updateProfileChildrenVisibilities() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(DBSearchIndexQueueEntry.fromItemIds(this._workstreamService.getWorkstreamMessageIdsByOrigins(this._itemIds), new SearchIndexType[]{SearchIndexType.VISIBILITIES}));
        return builder.build();
    }

    @Override
    public Set<DBSearchIndexQueueEntry> visitEntityVersionPublished() {
        return Sets.union(DBSearchIndexQueueEntry.fromItemIds(this._itemIds, SearchIndexType.ALL), this.updateChildren((Set<EntityId>)this.entities(), SearchIndexType.EXPIRATION));
    }

    @Override
    public Set<DBSearchIndexQueueEntry> visitEntityVersionArchived() {
        return Sets.union(DBSearchIndexQueueEntry.fromItemIds(this._itemIds, SearchIndexType.EXPIRATION), this.updateChildren((Set<EntityId>)this.entities(), SearchIndexType.EXPIRATION));
    }

    @Override
    public Set<DBSearchIndexQueueEntry> visitEntityVersionStatusUpdated() {
        return Sets.union(DBSearchIndexQueueEntry.fromItemIds(this._itemIds, SearchIndexType.ALL), this.updateChildren((Set<EntityId>)this.entities(), SearchIndexType.EXPIRATION));
    }

    @Nonnull
    private ImmutableSet<EntityId> entities() {
        return FluentIterable.from(this._itemIds).filter(EntityId.class).toSet();
    }

    @Override
    public Set<DBSearchIndexQueueEntry> visitCommentParentUpdate() {
        ImmutableMap<ItemId, WorkstreamMessageId> workstreamEntryIdsForAttachments = this._workstreamService.getMicroblogEntryIdsByAttachments(this._itemIds);
        return DBSearchIndexQueueEntry.fromItemIds((Iterable<? extends ItemId>)FluentIterable.from(this._itemIds).append((Iterable)workstreamEntryIdsForAttachments.values()), SearchIndexType.COMMENTS);
    }

    @Override
    public Set<DBSearchIndexQueueEntry> visitSubscriberUpdate() {
        return DBSearchIndexQueueEntry.fromItemIds(this._itemIds, SearchIndexType.SUBSCRIBERS);
    }

    @Override
    public Set<DBSearchIndexQueueEntry> visitEntityModifyDateUpdated() {
        return DBSearchIndexQueueEntry.fromItemIds(this._itemIds, SearchIndexType.MODIFY_DATE);
    }

    @Override
    public Set<DBSearchIndexQueueEntry> visitProfileMofifyDateUpdate() {
        return DBSearchIndexQueueEntry.fromItemIds(this._itemIds, SearchIndexType.MODIFY_DATE);
    }

    @Override
    public Set<DBSearchIndexQueueEntry> visitConversationUpdate() {
        return ImmutableSet.of();
    }

    @Override
    public Set<DBSearchIndexQueueEntry> visitConversationDelete() {
        return ImmutableSet.of();
    }

    @Override
    public Set<DBSearchIndexQueueEntry> visitChatMessageUpdate() {
        return ImmutableSet.of();
    }

    @Override
    public Set<DBSearchIndexQueueEntry> visitConversationCreate() {
        return ImmutableSet.of();
    }
}

